/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.registry;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WizardryTabs {
    private static Comparator<ItemStack> itemSorter;
    private static Comparator<ItemStack> spellItemSorter;
    public static final CreativeTabs WIZARDRY;
    public static final CreativeTabs SPELLS;

    public static void sort() {
        List<Item> orderedItemList = Arrays.asList(Item.func_150898_a((Block)WizardryBlocks.arcane_workbench), Item.func_150898_a((Block)WizardryBlocks.crystal_ore), Item.func_150898_a((Block)WizardryBlocks.crystal_block), Item.func_150898_a((Block)WizardryBlocks.crystal_flower), Item.func_150898_a((Block)WizardryBlocks.transportation_stone), WizardryItems.magic_crystal, WizardryItems.magic_wand, WizardryItems.apprentice_wand, WizardryItems.advanced_wand, WizardryItems.master_wand, WizardryItems.arcane_tome, WizardryItems.wizard_handbook, WizardryItems.basic_fire_wand, WizardryItems.basic_ice_wand, WizardryItems.basic_lightning_wand, WizardryItems.basic_necromancy_wand, WizardryItems.basic_earth_wand, WizardryItems.basic_sorcery_wand, WizardryItems.basic_healing_wand, WizardryItems.smoke_bomb, WizardryItems.firebomb, WizardryItems.poison_bomb, WizardryItems.blank_scroll, WizardryItems.identification_scroll, WizardryItems.mana_flask, WizardryItems.storage_upgrade, WizardryItems.siphon_upgrade, WizardryItems.condenser_upgrade, WizardryItems.range_upgrade, WizardryItems.duration_upgrade, WizardryItems.cooldown_upgrade, WizardryItems.blast_upgrade, WizardryItems.attunement_upgrade, WizardryItems.magic_silk, WizardryItems.armour_upgrade, WizardryItems.wizard_hat, WizardryItems.wizard_robe, WizardryItems.wizard_leggings, WizardryItems.wizard_boots, WizardryItems.wizard_hat_fire, WizardryItems.wizard_robe_fire, WizardryItems.wizard_leggings_fire, WizardryItems.wizard_boots_fire, WizardryItems.wizard_hat_ice, WizardryItems.wizard_robe_ice, WizardryItems.wizard_leggings_ice, WizardryItems.wizard_boots_ice, WizardryItems.wizard_hat_lightning, WizardryItems.wizard_robe_lightning, WizardryItems.wizard_leggings_lightning, WizardryItems.wizard_boots_lightning, WizardryItems.wizard_hat_necromancy, WizardryItems.wizard_robe_necromancy, WizardryItems.wizard_leggings_necromancy, WizardryItems.wizard_boots_necromancy, WizardryItems.wizard_hat_earth, WizardryItems.wizard_robe_earth, WizardryItems.wizard_leggings_earth, WizardryItems.wizard_boots_earth, WizardryItems.wizard_hat_sorcery, WizardryItems.wizard_robe_sorcery, WizardryItems.wizard_leggings_sorcery, WizardryItems.wizard_boots_sorcery, WizardryItems.wizard_hat_healing, WizardryItems.wizard_robe_healing, WizardryItems.wizard_leggings_healing, WizardryItems.wizard_boots_healing);
        itemSorter = Ordering.explicit(orderedItemList).onResultOf((Function)new Function<ItemStack, Item>(){

            public Item apply(ItemStack input) {
                return input.func_77973_b();
            }
        });
        spellItemSorter = new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1.func_77973_b() instanceof ItemSpellBook && stack2.func_77973_b() instanceof ItemSpellBook || stack1.func_77973_b() instanceof ItemScroll && stack2.func_77973_b() instanceof ItemScroll) {
                    Spell spell1 = Spell.get(stack1.func_77952_i());
                    Spell spell2 = Spell.get(stack2.func_77952_i());
                    return spell1.compareTo(spell2);
                }
                if (stack1.func_77973_b() instanceof ItemScroll) {
                    return 1;
                }
                if (stack2.func_77973_b() instanceof ItemScroll) {
                    return -1;
                }
                return 0;
            }
        };
    }

    static {
        WIZARDRY = new CreativeTabs("wizardry"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(WizardryItems.wizard_handbook);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> items) {
                super.func_78018_a(items);
                Collections.sort(items, itemSorter);
            }
        };
        SPELLS = new CreativeTabs("wizardryspells"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(WizardryItems.spell_book);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> items) {
                super.func_78018_a(items);
                Collections.sort(items, spellItemSorter);
            }

            public boolean hasSearchBar() {
                return true;
            }

            @SideOnly(value=Side.CLIENT)
            public String func_78015_f() {
                return "item_search.png";
            }
        };
    }
}

