/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ForestsCurse
extends Spell {
    public ForestsCurse() {
        super(Tier.MASTER, 75, Element.EARTH, "forests_curse", SpellType.ATTACK, 200, EnumAction.BOW, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(5.0 * (double)modifiers.get(WizardryItems.blast_upgrade), caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target) || MagicDamage.isEntityImmune(MagicDamage.DamageType.POISON, (Entity)target)) continue;
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.POISON), 4.0f * modifiers.get("damage"));
            target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)(140.0f * modifiers.get(WizardryItems.duration_upgrade)), 2));
            target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(140.0f * modifiers.get(WizardryItems.duration_upgrade)), 2));
            target.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(140.0f * modifiers.get(WizardryItems.duration_upgrade)), 2));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 50.0f * modifiers.get(WizardryItems.blast_upgrade)) {
                double radius = (1.0 + world.field_73012_v.nextDouble() * 4.0) * (double)modifiers.get(WizardryItems.blast_upgrade);
                double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                float brightness = world.field_73012_v.nextFloat() / 4.0f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.2, 0.0, 0, 0.05f + brightness, 0.2f + brightness, 0.0f);
                brightness = world.field_73012_v.nextFloat() / 4.0f;
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.05, 0.0, 50, 0.1f + brightness, 0.2f + brightness, 0.0f);
                Wizardry.proxy.spawnParticle(WizardryParticleType.LEAF, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.01, 0.0, 40 + world.field_73012_v.nextInt(12));
                ++i;
            }
        }
        WizardryUtilities.playSoundAtPlayer(caster, SoundEvents.field_187855_gD, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }
}

