/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryParticleType;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class LifeDrain
extends Spell {
    public LifeDrain() {
        super(Tier.APPRENTICE, 10, Element.NECROMANCY, "life_drain", SpellType.ATTACK, 0, EnumAction.NONE, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        Vec3d look = caster.func_70040_Z();
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * modifiers.get(WizardryItems.range_upgrade));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY && WizardryUtilities.isLiving(rayTrace.field_72308_g)) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (ticksInUse % 12 == 0) {
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), 2.0f * modifiers.get("damage"));
                caster.func_70691_i(1.0f);
            }
        }
        if (world.field_72995_K) {
            for (int i = 5; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                if (i % 5 == 0) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.1f, 0.0f, 0.0f);
                }
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, -0.05 * look.field_72450_a * (double)i, -0.05 * look.field_72448_b * (double)i, -0.05 * look.field_72449_c * (double)i, 8 + world.field_73012_v.nextInt(6), 0.5f, 0.0f, 0.0f);
            }
        }
        if (ticksInUse % 18 == 0) {
            if (ticksInUse == 0) {
                WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_SUMMONING, 1.0f, 0.6f);
            }
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_LOOP_CRACKLE, 2.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        Vec3d vec = new Vec3d(target.field_70165_t - caster.field_70165_t, target.field_70163_u - caster.field_70163_u, target.field_70161_v - caster.field_70161_v).func_72432_b();
        if (target != null && ticksInUse % 12 == 0) {
            WizardryUtilities.attackEntityWithoutKnockback((Entity)target, MagicDamage.causeDirectMagicDamage((Entity)caster, MagicDamage.DamageType.MAGIC), 2.0f * modifiers.get("damage"));
            caster.func_70691_i(1.0f);
        }
        if (world.field_72995_K) {
            for (int i = 5; i < (int)(25.0f * modifiers.get(WizardryItems.range_upgrade)); i += 2) {
                double x1 = caster.field_70165_t + vec.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + vec.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + vec.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                if (i % 5 == 0) {
                    Wizardry.proxy.spawnParticle(WizardryParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.1f, 0.0f, 0.0f);
                }
                Wizardry.proxy.spawnParticle(WizardryParticleType.SPARKLE, world, x1, y1, z1, -0.05 * vec.field_72450_a * (double)i, -0.05 * vec.field_72448_b * (double)i, -0.05 * vec.field_72449_c * (double)i, 8 + world.field_73012_v.nextInt(6), 0.5f, 0.0f, 0.0f);
            }
        }
        if (ticksInUse % 18 == 0) {
            if (ticksInUse == 0) {
                caster.func_184185_a(WizardrySounds.SPELL_SUMMONING, 1.0f, 0.6f);
            }
            caster.func_184185_a(WizardrySounds.SPELL_LOOP_CRACKLE, 2.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

