/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryAchievements;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LightningBolt
extends Spell {
    public static final String NBT_KEY = "summoningPlayer";

    public LightningBolt() {
        super(Tier.ADVANCED, 40, Element.LIGHTNING, "lightning_bolt", SpellType.ATTACK, 80, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        BlockPos pos;
        RayTraceResult rayTrace = WizardryUtilities.rayTrace(200.0, world, (EntityLivingBase)caster, false);
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175710_j((pos = rayTrace.func_178782_a()).func_177984_a())) {
            if (!world.field_72995_K) {
                EntityLightningBolt entitylightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                world.func_72942_c((Entity)entitylightning);
                NBTTagCompound entityNBT = entitylightning.getEntityData();
                entityNBT.func_186854_a(NBT_KEY, caster.func_110124_au());
            }
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        int z;
        int y;
        int x;
        if (target != null && world.func_175710_j(new BlockPos(x = (int)target.field_70165_t, y = (int)target.field_70163_u, z = (int)target.field_70161_v))) {
            if (!world.field_72995_K) {
                EntityLightningBolt entitylightning = new EntityLightningBolt(world, (double)x, (double)y, (double)z, false);
                world.func_72942_c((Entity)entitylightning);
            }
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }

    @SubscribeEvent
    public static void onEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        if (event.getLightning().getEntityData() != null && event.getLightning().getEntityData().func_186855_b(NBT_KEY)) {
            EntityPlayer player = (EntityPlayer)WizardryUtilities.getEntityByUUID(event.getLightning().field_70170_p, event.getLightning().getEntityData().func_186857_a(NBT_KEY));
            if (event.getEntity() instanceof EntityCreeper) {
                player.func_71029_a((StatBase)WizardryAchievements.charge_creeper);
            }
            if (event.getEntity() instanceof EntityPig) {
                player.func_71029_a((StatBase)WizardryAchievements.frankenstein);
            }
        }
    }
}

