/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Telekinesis
extends Spell {
    public Telekinesis() {
        super(Tier.BASIC, 5, Element.SORCERY, "telekinesis", SpellType.UTILITY, 5, EnumAction.NONE, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        IBlockState blockstate;
        RayTraceResult rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * modifiers.get(WizardryItems.range_upgrade), 3.0f);
        if (rayTrace != null && rayTrace.field_72308_g != null) {
            EntityPlayer target;
            if (rayTrace.field_72308_g instanceof EntityItem) {
                Entity entityHit = rayTrace.field_72308_g;
                entityHit.field_70159_w = (caster.field_70165_t - entityHit.field_70165_t) / 6.0;
                entityHit.field_70181_x = (caster.field_70163_u + (double)caster.eyeHeight - entityHit.field_70163_u) / 6.0;
                entityHit.field_70179_y = (caster.field_70161_v - entityHit.field_70161_v) / 6.0;
                entityHit.func_184185_a(WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                caster.func_184609_a(hand);
                return true;
            }
            if (rayTrace.field_72308_g instanceof EntityPlayer && Wizardry.settings.telekineticDisarmament && !(target = (EntityPlayer)rayTrace.field_72308_g).func_184614_ca().func_190926_b()) {
                if (!world.field_72995_K) {
                    EntityItem item = target.func_70099_a(target.func_184614_ca(), 0.0f);
                    item.field_70159_w = (caster.field_70165_t - target.field_70165_t) / 20.0;
                    item.field_70179_y = (caster.field_70161_v - target.field_70161_v) / 20.0;
                }
                target.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                target.func_184185_a(WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
                caster.func_184609_a(hand);
                return true;
            }
        }
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && (blockstate = world.func_180495_p(new BlockPos((Vec3i)rayTrace.func_178782_a()))).func_177230_c().func_180639_a(world, rayTrace.func_178782_a(), blockstate, caster, hand, rayTrace.field_178784_b, 0.0f, 0.0f, 0.0f)) {
            WizardryUtilities.playSoundAtPlayer(caster, WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer && !target.func_184614_ca().func_190926_b()) {
            if (!world.field_72995_K) {
                EntityItem item = target.func_70099_a(target.func_184614_ca(), 0.0f);
                item.field_70159_w = (caster.field_70165_t - target.field_70165_t) / 20.0;
                item.field_70179_y = (caster.field_70161_v - target.field_70161_v) / 20.0;
            }
            target.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            target.func_184185_a(WizardrySounds.SPELL_CONJURATION, 1.0f, 1.0f);
            caster.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

