/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.WizardData;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class WizardryUtilities {
    public static final EntityEquipmentSlot[] ARMOUR_SLOTS;
    private static final DataParameter<Boolean> POWERED;

    public static boolean canBlockBeReplaced(World world, BlockPos pos) {
        return world.func_175623_d(new BlockPos((Vec3i)pos)) || world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public static boolean canBlockBeReplacedB(World world, BlockPos pos) {
        return WizardryUtilities.canBlockBeReplaced(world, pos) && !world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return world.func_175623_d(new BlockPos((Vec3i)pos)) ? false : world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
    }

    public static int getNearestFloorLevel(World world, BlockPos pos, int range) {
        int yCoord = -2;
        for (int i = -range; i <= range; ++i) {
            if (!world.isSideSolid(pos.func_177981_b(i), EnumFacing.UP) || !world.func_175623_d(pos.func_177981_b(i + 1)) && world.isSideSolid(pos.func_177981_b(i + 1), EnumFacing.UP) || i >= yCoord - pos.func_177956_o() && yCoord != -2) continue;
            yCoord = pos.func_177956_o() + i;
        }
        return yCoord + 1;
    }

    public static int getNearestFloorLevelB(World world, BlockPos pos, int range) {
        int yCoord = -2;
        for (int i = -range; i <= range; ++i) {
            if (!world.func_175623_d(new BlockPos((Vec3i)pos.func_177981_b(i + 1))) || !world.func_180495_p(pos.func_177981_b(i)).func_185904_a().func_76224_d() && !world.isSideSolid(pos.func_177981_b(i), EnumFacing.UP) || i >= yCoord - pos.func_177956_o() && yCoord != -2) continue;
            yCoord = pos.func_177956_o() + i;
        }
        return yCoord + 1;
    }

    public static int getNearestFloorLevelC(World world, BlockPos pos, int range) {
        int yCoord = -2;
        for (int i = -range; i <= range; ++i) {
            if (!world.func_175623_d(new BlockPos((Vec3i)pos.func_177981_b(i + 1))) || i >= yCoord - pos.func_177956_o() && yCoord != -2) continue;
            yCoord = pos.func_177956_o() + i;
        }
        return yCoord + 1;
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Entity entity, int horizontalRange, int verticalRange) {
        World world = entity.field_70170_p;
        ArrayList<BlockPos> possibleLocations = new ArrayList<BlockPos>();
        BlockPos origin = new BlockPos(entity);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                int y = WizardryUtilities.getNearestFloorLevel(world, origin.func_177982_a(x, 0, z), verticalRange);
                if (y <= -1) continue;
                possibleLocations.add(new BlockPos(origin.func_177958_n() + x, y, origin.func_177952_p() + z));
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleLocations.get(world.field_73012_v.nextInt(possibleLocations.size()));
    }

    public static IBlockState getBlockEntityIsStandingOn(Entity entity) {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.func_174813_aQ().field_72338_b - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
        return entity.field_70170_p.func_180495_p(pos);
    }

    public static List<EntityLivingBase> getEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return WizardryUtilities.getEntitiesWithinRadius(radius, x, y, z, world, EntityLivingBase.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
        }
        return entityList;
    }

    @Nullable
    public static Entity getEntityByUUID(World world, UUID id) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, SoundCategory category, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, category, volume, pitch);
    }

    public static void playSoundAtPlayer(EntityPlayer player, SoundEvent sound, float volume, float pitch) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, sound, SoundCategory.PLAYERS, volume, pitch);
    }

    @Nullable
    public static Entity getRider(Entity entity) {
        return entity.func_184188_bt() != null && !entity.func_184188_bt().isEmpty() ? (Entity)entity.func_184188_bt().get(0) : null;
    }

    public static boolean attackEntityWithoutKnockback(Entity entity, DamageSource source, float amount) {
        double vx = entity.field_70159_w;
        double vy = entity.field_70181_x;
        double vz = entity.field_70179_y;
        boolean succeeded = entity.func_70097_a(source, amount);
        entity.field_70159_w = vx;
        entity.field_70181_x = vy;
        entity.field_70179_y = vz;
        return succeeded;
    }

    public static void applyStandardKnockback(Entity attacker, EntityLivingBase target) {
        double dx = attacker.field_70165_t - target.field_70165_t;
        double dz = attacker.field_70161_v - target.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        target.func_70653_a(null, 0.4f, dx, dz);
    }

    public static double getPlayerEyesPos(EntityPlayer player) {
        return player.func_174813_aQ().field_72338_b + (double)player.func_70047_e();
    }

    public static List<ItemStack> getHotbar(EntityPlayer player) {
        NonNullList hotbar = NonNullList.func_191196_a();
        hotbar.addAll((Collection)player.field_71071_by.field_70462_a.subList(0, 9));
        return hotbar;
    }

    public static List<ItemStack> getPrioritisedHotbarAndOffhand(EntityPlayer player) {
        List<ItemStack> hotbar = WizardryUtilities.getHotbar(player);
        hotbar.add(0, player.func_184592_cb());
        hotbar.remove(player.func_184614_ca());
        hotbar.add(0, player.func_184614_ca());
        return hotbar;
    }

    public static boolean doesPlayerHaveItem(EntityPlayer player, Item item) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_184439_c) {
            if (stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerOp(EntityPlayer player, MinecraftServer server) {
        return server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH()) != null;
    }

    public static boolean isLiving(Entity entity) {
        return entity instanceof EntityLivingBase && !(entity instanceof EntityArmorStand);
    }

    public static void chargeCreeper(EntityCreeper creeper) {
        creeper.func_184212_Q().func_187227_b(POWERED, (Object)true);
    }

    @Nullable
    public static RayTraceResult rayTrace(double range, World world, EntityLivingBase entity, boolean hitLiquids) {
        Vec3d start = new Vec3d(entity.field_70165_t, entity.func_174813_aQ().field_72338_b + (double)entity.func_70047_e(), entity.field_70161_v);
        Vec3d look = entity.func_70040_Z();
        Vec3d end = start.func_72441_c(look.field_72450_a * range, look.field_72448_b * range, look.field_72449_c * range);
        return world.func_72901_a(start, end, hitLiquids);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, EntityLivingBase entity, double range) {
        double dx = entity.func_70040_Z().field_72450_a * range;
        double dy = entity.func_70040_Z().field_72448_b * range;
        double dz = entity.func_70040_Z().field_72449_c * range;
        HashSet<Entity> hashset = new HashSet<Entity>(1);
        hashset.add((Entity)entity);
        return WizardryUtilities.tracePath(world, (float)entity.field_70165_t, (float)(entity.func_174813_aQ().field_72338_b + (double)entity.func_70047_e()), (float)entity.field_70161_v, (float)(entity.field_70165_t + dx), (float)(entity.field_70163_u + (double)entity.func_70047_e() + dy), (float)(entity.field_70161_v + dz), 1.0f, hashset, false);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, EntityLivingBase entity, double range, float borderSize) {
        double dx = entity.func_70040_Z().field_72450_a * range;
        double dy = entity.func_70040_Z().field_72448_b * range;
        double dz = entity.func_70040_Z().field_72449_c * range;
        HashSet<Entity> hashset = new HashSet<Entity>(1);
        hashset.add((Entity)entity);
        return WizardryUtilities.tracePath(world, (float)entity.field_70165_t, (float)(entity.func_174813_aQ().field_72338_b + (double)entity.func_70047_e()), (float)entity.field_70161_v, (float)(entity.field_70165_t + dx), (float)(entity.field_70163_u + (double)entity.func_70047_e() + dy), (float)(entity.field_70161_v + dz), borderSize, hashset, false);
    }

    @Nullable
    public static RayTraceResult tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float borderSize, HashSet<Entity> excluded, boolean collideablesOnly) {
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = x < tx ? x : tx;
        float minY = y < ty ? y : ty;
        float minZ = z < tz ? z : tz;
        float maxX = x > tx ? x : tx;
        float maxY = y > ty ? y : ty;
        float maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        RayTraceResult blockHit = world.func_72933_a(startVec, endVec);
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (blockHit != null) {
            maxDistance = (float)blockHit.field_72307_f.func_72438_d(startVec);
        }
        Entity closestHitEntity = null;
        float closestHit = maxDistance;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            RayTraceResult intercept;
            if (!ent.func_70067_L() && collideablesOnly || (excluded == null || excluded.contains(ent)) && excluded != null) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            blockHit = new RayTraceResult(closestHitEntity);
        }
        return blockHit;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        VertexBuffer buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)u * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)(v + height) * f1)).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(u + width) * f), (double)((float)v * f1)).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)u * f), (double)((float)v * f1)).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTexturedRect(int x, int y, int width, int height) {
        WizardryUtilities.drawTexturedRect(x, y, 0, 0, width, height, width, height);
    }

    @Deprecated
    public static boolean verifyUUIDString(String string) {
        return string != null && string.matches("/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/");
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> NBTTagList mapToNBT(Map<K, V> map, Function<K, L> keyFunction, Function<V, W> valueFunction, String keyTagName, String valueTagName) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            NBTTagCompound mapping = new NBTTagCompound();
            mapping.func_74782_a(keyTagName, (NBTBase)keyFunction.apply(entry.getKey()));
            mapping.func_74782_a(valueTagName, (NBTBase)valueFunction.apply(entry.getValue()));
            tagList.func_74742_a((NBTBase)mapping);
        }
        return tagList;
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> NBTTagList mapToNBT(Map<K, V> map, Function<K, L> keyFunction, Function<V, W> valueFunction) {
        return WizardryUtilities.mapToNBT(map, keyFunction, valueFunction, "key", "value");
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> Map<K, V> NBTToMap(NBTTagList tagList, Function<L, K> keyFunction, Function<W, V> valueFunction, String keyTagName, String valueTagName) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound mapping = tagList.func_150305_b(i);
            NBTBase keyTag = mapping.func_74781_a(keyTagName);
            NBTBase valueTag = mapping.func_74781_a(valueTagName);
            Object key = null;
            try {
                key = keyFunction.apply(keyTag);
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading map from NBT: unexpected tag type " + NBTBase.field_82578_b[keyTag.func_74732_a()], (Throwable)e);
            }
            Object value = null;
            try {
                value = valueFunction.apply(valueTag);
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading map from NBT: unexpected tag type " + NBTBase.field_82578_b[valueTag.func_74732_a()], (Throwable)e);
            }
            map.put(key, value);
        }
        return map;
    }

    public static <K, V, L extends NBTBase, W extends NBTBase> Map<K, V> NBTToMap(NBTTagList tagList, Function<L, K> keyFunction, Function<W, V> valueFunction) {
        return WizardryUtilities.NBTToMap(tagList, keyFunction, valueFunction, "key", "value");
    }

    public static <E, T extends NBTBase> NBTTagList listToNBT(Collection<E> list, Function<E, T> function) {
        NBTTagList tagList = new NBTTagList();
        for (E element : list) {
            tagList.func_74742_a((NBTBase)function.apply(element));
        }
        return tagList;
    }

    public static <E, T extends NBTBase> Collection<E> NBTToList(NBTTagList tagList, Function<T, E> function) {
        ArrayList<E> list = new ArrayList<E>();
        NBTTagList tagList2 = tagList.func_74737_b();
        while (!tagList2.func_82582_d()) {
            NBTBase tag = tagList2.func_74744_a(0);
            try {
                list.add(function.apply(tag));
            }
            catch (ClassCastException e) {
                Wizardry.logger.error("Error when reading list from NBT: unexpected tag type " + NBTBase.field_82578_b[tag.func_74732_a()], (Throwable)e);
            }
        }
        return list;
    }

    public static void removeUniqueId(NBTTagCompound tag, String key) {
        tag.func_82580_o(key + "Most");
        tag.func_82580_o(key + "Least");
    }

    public static NBTTagCompound UUIDtoTagCompound(UUID id) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_186854_a("uuid", id);
        return tag;
    }

    public static UUID tagCompoundToUUID(NBTTagCompound tag) {
        return tag.func_186857_a("uuid");
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        Entity controller;
        NBTTagCompound entityNBT;
        if (attacker == null || target == null) {
            return false;
        }
        if (target == attacker) {
            return false;
        }
        if (target instanceof ISummonedCreature && ((ISummonedCreature)target).getCaster() == attacker) {
            return false;
        }
        if (target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_186855_b("controllingEntity") && attacker == WizardryUtilities.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) {
            return false;
        }
        return !(attacker instanceof EntityPlayer) || WizardData.get((EntityPlayer)attacker) == null || !(target instanceof EntityPlayer ? WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)target) : (target instanceof ISummonedCreature ? ((ISummonedCreature)target).getCaster() instanceof EntityPlayer && WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)((ISummonedCreature)target).getCaster()) : target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(WizardryPotions.mind_control) && (entityNBT = target.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (controller = WizardryUtilities.getEntityByUUID(target.field_70170_p, entityNBT.func_186857_a("controllingEntity"))) instanceof EntityPlayer && WizardData.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)controller)));
    }

    public static boolean isPlayerAlly(EntityPlayer allyOf, EntityPlayer possibleAlly) {
        WizardData properties = WizardData.get(allyOf);
        return properties != null && properties.isPlayerAlly(possibleAlly);
    }

    public static int getStandardWeightedRandomSpellId(Random random) {
        return WizardryUtilities.getStandardWeightedRandomSpellId(random, false);
    }

    public static int getStandardWeightedRandomSpellId(Random random, boolean nonContinuous) {
        Tier tier = Tier.getWeightedRandomTier(random, new Tier[0]);
        List<Spell> spells = Spell.getSpells(new Spell.TierElementFilter(tier, null));
        if (nonContinuous) {
            spells.retainAll(Spell.getSpells(Spell.nonContinuousSpells));
        }
        if (spells.isEmpty()) {
            spells = Spell.getSpells(new Spell.TierElementFilter(Tier.BASIC, null));
            if (nonContinuous) {
                spells.retainAll(Spell.getSpells(Spell.nonContinuousSpells));
            }
        }
        return spells.get(random.nextInt(spells.size())).id();
    }

    public static Item getArmour(Element element, EntityEquipmentSlot slot) {
        if (slot == null || slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) {
            throw new IllegalArgumentException("Must be a valid armour slot");
        }
        if (element == null) {
            element = Element.MAGIC;
        }
        return WizardryItems.ARMOUR_MAP.get(ImmutablePair.of((Object)slot, (Object)((Object)element)));
    }

    public static Item getWand(Tier tier, Element element) {
        if (tier == null) {
            throw new NullPointerException("The given tier cannot be null.");
        }
        if (element == null) {
            element = Element.MAGIC;
        }
        return WizardryItems.WAND_MAP.get(ImmutablePair.of((Object)((Object)tier), (Object)((Object)element)));
    }

    static {
        ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>(Arrays.asList(EntityEquipmentSlot.values()));
        slots.removeIf(slot -> slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR);
        ARMOUR_SLOTS = slots.toArray(new EntityEquipmentSlot[0]);
        POWERED = (DataParameter)ReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String[])new String[]{"POWERED", "field_184714_b"});
    }
}

