/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.spell.Spell;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class WizardryUtilities {
    public static int getNearestFloorLevel(World world, int x, int y, int z, int range) {
        int yCoord = -2;
        for (int i = y - range; i <= y + range; ++i) {
            if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)i, (int)z)) continue;
            if (!world.func_147437_c(x, i + 1, z)) {
                if (World.func_147466_a((IBlockAccess)world, (int)x, (int)(i + 1), (int)z)) continue;
            }
            if (i - y >= yCoord - y && yCoord != -2) continue;
            yCoord = i;
        }
        return yCoord + 1;
    }

    public static boolean canBlockBeReplaced(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z);
    }

    public static boolean canBlockBeReplacedB(World world, int x, int y, int z) {
        return (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z)) && !world.func_147439_a(x, y, z).func_149688_o().func_76224_d();
    }

    public static boolean isBlockUnbreakable(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) ? false : world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) == -1.0f;
    }

    public static int getNearestFloorLevelB(World world, int x, int y, int z, int range) {
        int yCoord = -2;
        for (int i = y - range; i <= y + range; ++i) {
            if (!world.func_147437_c(x, i + 1, z)) continue;
            if (!world.func_147439_a(x, i, z).func_149688_o().func_76224_d()) {
                if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)i, (int)z)) continue;
            }
            if (i - y >= yCoord - y && yCoord != -2) continue;
            yCoord = i;
        }
        return yCoord + 1;
    }

    public static int getNearestFloorLevelC(World world, int x, int y, int z, int range) {
        int yCoord = -2;
        for (int i = y - range; i <= y + range; ++i) {
            if (!world.func_147437_c(x, i + 1, z) || i - y >= yCoord - y && yCoord != -2) continue;
            yCoord = i;
        }
        return yCoord + 1;
    }

    public static Block getBlockEntityIsStandingOn(Entity entity) {
        return entity.field_70170_p.func_147439_a(MathHelper.func_76128_c((double)entity.field_70165_t), (int)WizardryUtilities.getEntityFeetPos(entity) - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
    }

    public static List<EntityLivingBase> getEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return WizardryUtilities.getEntitiesWithinRadius(radius, x, y, z, world, EntityLivingBase.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius));
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
        }
        return entityList;
    }

    public static Entity getEntityByUUID(World world, UUID id) {
        for (Object object : world.field_72996_f) {
            Entity entity;
            if (!(object instanceof Entity) || !(entity = (Entity)object).func_110124_au().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public static MovingObjectPosition rayTrace(double range, World world, EntityLivingBase entity, boolean hitLiquids) {
        Vec3 vec3 = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 vec31 = entity.func_70040_Z();
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * range, vec31.field_72448_b * range, vec31.field_72449_c * range);
        return world.func_72901_a(vec3, vec32, hitLiquids);
    }

    public static MovingObjectPosition standardEntityRayTrace(World world, EntityLivingBase entity, double range) {
        double dx = entity.func_70040_Z().field_72450_a * range;
        double dy = entity.func_70040_Z().field_72448_b * range;
        double dz = entity.func_70040_Z().field_72449_c * range;
        HashSet<Entity> hashset = new HashSet<Entity>(1);
        hashset.add((Entity)entity);
        return WizardryUtilities.tracePath(world, (float)entity.field_70165_t, (float)(entity.field_70163_u + (double)entity.func_70047_e()), (float)entity.field_70161_v, (float)(entity.field_70165_t + dx), (float)(entity.field_70163_u + (double)entity.func_70047_e() + dy), (float)(entity.field_70161_v + dz), 1.0f, hashset, false);
    }

    public static MovingObjectPosition standardEntityRayTrace(World world, EntityLivingBase entity, double range, float borderSize) {
        double dx = entity.func_70040_Z().field_72450_a * range;
        double dy = entity.func_70040_Z().field_72448_b * range;
        double dz = entity.func_70040_Z().field_72449_c * range;
        HashSet<Entity> hashset = new HashSet<Entity>(1);
        hashset.add((Entity)entity);
        return WizardryUtilities.tracePath(world, (float)entity.field_70165_t, (float)(entity.field_70163_u + (double)entity.func_70047_e()), (float)entity.field_70161_v, (float)(entity.field_70165_t + dx), (float)(entity.field_70163_u + (double)entity.func_70047_e() + dy), (float)(entity.field_70161_v + dz), borderSize, hashset, false);
    }

    public static MovingObjectPosition tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float borderSize, HashSet<Entity> excluded, boolean collideablesOnly) {
        Vec3 startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        Vec3 lookVec = Vec3.func_72443_a((double)(tx - x), (double)(ty - y), (double)(tz - z));
        Vec3 endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        float minX = x < tx ? x : tx;
        float minY = y < ty ? y : ty;
        float minZ = z < tz ? z : tz;
        float maxX = x > tx ? x : tx;
        float maxY = y > ty ? y : ty;
        float maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        MovingObjectPosition blockHit = world.func_72933_a(startVec, endVec);
        startVec = Vec3.func_72443_a((double)x, (double)y, (double)z);
        endVec = Vec3.func_72443_a((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (blockHit != null) {
            maxDistance = (float)blockHit.field_72307_f.func_72438_d(startVec);
        }
        Entity closestHitEntity = null;
        float closestHit = maxDistance;
        float currentHit = 0.0f;
        for (Entity ent : allEntities) {
            MovingObjectPosition intercept;
            if (!ent.func_70067_L() && collideablesOnly || (excluded == null || excluded.contains(ent)) && excluded != null) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.field_70121_D;
            if (entityBb == null || (intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            blockHit = new MovingObjectPosition(closestHitEntity);
        }
        return blockHit;
    }

    public static double getPlayerEyesPos(EntityPlayer player) {
        return Wizardry.proxy.getPlayerEyesPos(player);
    }

    public static double getEntityFeetPos(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return WizardryUtilities.getPlayerEyesPos((EntityPlayer)entity) - (double)(entity.field_70131_O * 0.85f);
        }
        return entity.field_70163_u;
    }

    public static boolean verifyUUIDString(String string) {
        return string != null && string.matches("/^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/");
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        Entity controller;
        NBTTagCompound entityNBT;
        if (target == attacker) {
            return false;
        }
        if (target instanceof EntitySummonedCreature && ((EntitySummonedCreature)target).getCaster() == attacker) {
            return false;
        }
        if (target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(Wizardry.mindControl) && (entityNBT = target.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && attacker == WizardryUtilities.getEntityByUUID(target.field_70170_p, UUID.fromString(entityNBT.func_74779_i("controllingEntity")))) {
            return false;
        }
        return !(attacker instanceof EntityPlayer) || ExtendedPlayer.get((EntityPlayer)attacker) == null || !(target instanceof EntityPlayer ? ExtendedPlayer.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)target) : (target instanceof EntitySummonedCreature ? ((EntitySummonedCreature)target).getCaster() instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)((EntitySummonedCreature)target).getCaster()) : target instanceof EntityLiving && ((EntityLivingBase)target).func_70644_a(Wizardry.mindControl) && (entityNBT = target.getEntityData()) != null && entityNBT.func_74764_b("controllingEntity") && (controller = WizardryUtilities.getEntityByUUID(target.field_70170_p, UUID.fromString(entityNBT.func_74779_i("controllingEntity")))) instanceof EntityPlayer && ExtendedPlayer.get((EntityPlayer)attacker).isPlayerAlly((EntityPlayer)controller)));
    }

    public static boolean isPlayerAlly(EntityPlayer allyOf, EntityPlayer possibleAlly) {
        ExtendedPlayer properties = ExtendedPlayer.get(allyOf);
        return properties != null && properties.isPlayerAlly(possibleAlly);
    }

    public static int getStandardWeightedRandomSpellId(Random random) {
        return WizardryUtilities.getStandardWeightedRandomSpellId(random, false);
    }

    public static int getStandardWeightedRandomSpellId(Random random, boolean nonContinuous) {
        int randomiser = random.nextInt(20);
        EnumTier tier = randomiser < 12 ? EnumTier.BASIC : (randomiser < 17 ? EnumTier.APPRENTICE : (randomiser < 19 ? EnumTier.ADVANCED : EnumTier.MASTER));
        List<Spell> spells = Spell.getSpells(new Spell.TierElementFilter(tier, null));
        if (nonContinuous) {
            spells.retainAll(Spell.getSpells(Spell.nonContinuousSpells));
        }
        if (spells.isEmpty()) {
            spells = Spell.getSpells(new Spell.TierElementFilter(EnumTier.BASIC, null));
            if (nonContinuous) {
                spells.retainAll(Spell.getSpells(Spell.nonContinuousSpells));
            }
        }
        return spells.get(random.nextInt(spells.size())).id();
    }

    public static Item getArmour(EnumElement element, int slot) {
        Item armour = null;
        if (element == null) {
            switch (slot) {
                case 0: {
                    armour = Wizardry.wizardHat;
                    break;
                }
                case 1: {
                    armour = Wizardry.wizardRobe;
                    break;
                }
                case 2: {
                    armour = Wizardry.wizardLeggings;
                    break;
                }
                case 3: {
                    armour = Wizardry.wizardBoots;
                    break;
                }
            }
        } else {
            block6 : switch (element) {
                case FIRE: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatFire;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeFire;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsFire;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsFire;
                            break block6;
                        }
                    }
                    break;
                }
                case HEALING: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatHealing;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeHealing;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsHealing;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsHealing;
                            break block6;
                        }
                    }
                    break;
                }
                case ICE: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatIce;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeIce;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsIce;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsIce;
                            break block6;
                        }
                    }
                    break;
                }
                case LIGHTNING: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatLightning;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeLightning;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsLightning;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsLightning;
                            break block6;
                        }
                    }
                    break;
                }
                case NECROMANCY: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatNecromancy;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeNecromancy;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsNecromancy;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsNecromancy;
                            break block6;
                        }
                    }
                    break;
                }
                case SORCERY: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatSorcery;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeSorcery;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsSorcery;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsSorcery;
                            break block6;
                        }
                    }
                    break;
                }
                case EARTH: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHatEarth;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobeEarth;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggingsEarth;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBootsEarth;
                            break block6;
                        }
                    }
                    break;
                }
                default: {
                    switch (slot) {
                        case 0: {
                            armour = Wizardry.wizardHat;
                            break block6;
                        }
                        case 1: {
                            armour = Wizardry.wizardRobe;
                            break block6;
                        }
                        case 2: {
                            armour = Wizardry.wizardLeggings;
                            break block6;
                        }
                        case 3: {
                            armour = Wizardry.wizardBoots;
                            break block6;
                        }
                    }
                }
            }
        }
        return armour;
    }

    public static Item getWand(EnumTier tier, EnumElement element) {
        Item wand = null;
        if (element == null) {
            switch (tier) {
                case BASIC: {
                    wand = Wizardry.magicWand;
                    break;
                }
                case APPRENTICE: {
                    wand = Wizardry.apprenticeWand;
                    break;
                }
                case ADVANCED: {
                    wand = Wizardry.advancedWand;
                    break;
                }
                case MASTER: {
                    wand = Wizardry.masterWand;
                    break;
                }
            }
        } else {
            block6 : switch (element) {
                case FIRE: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicFireWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeFireWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedFireWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterFireWand;
                            break block6;
                        }
                    }
                    break;
                }
                case HEALING: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicHealingWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeHealingWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedHealingWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterHealingWand;
                            break block6;
                        }
                    }
                    break;
                }
                case ICE: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicIceWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeIceWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedIceWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterIceWand;
                            break block6;
                        }
                    }
                    break;
                }
                case LIGHTNING: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicLightningWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeLightningWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedLightningWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterLightningWand;
                            break block6;
                        }
                    }
                    break;
                }
                case NECROMANCY: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicNecromancyWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeNecromancyWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedNecromancyWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterNecromancyWand;
                            break block6;
                        }
                    }
                    break;
                }
                case SORCERY: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicSorceryWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeSorceryWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedSorceryWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterSorceryWand;
                            break block6;
                        }
                    }
                    break;
                }
                case EARTH: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.basicEarthWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeEarthWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedEarthWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterEarthWand;
                            break block6;
                        }
                    }
                    break;
                }
                default: {
                    switch (tier) {
                        case BASIC: {
                            wand = Wizardry.magicWand;
                            break block6;
                        }
                        case APPRENTICE: {
                            wand = Wizardry.apprenticeWand;
                            break block6;
                        }
                        case ADVANCED: {
                            wand = Wizardry.advancedWand;
                            break block6;
                        }
                        case MASTER: {
                            wand = Wizardry.masterWand;
                            break block6;
                        }
                    }
                }
            }
        }
        return wand;
    }
}

