/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ItemWand;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public abstract class EntitySummonedCreature
extends EntityCreature
implements IEntityAdditionalSpawnData {
    public int lifetime = 600;
    private WeakReference<EntityLivingBase> caster;
    private UUID casterUUID;
    protected IEntitySelector targetSelector;

    public EntitySummonedCreature(World world) {
        super(world);
        this.field_70728_aV = 0;
    }

    public EntitySummonedCreature(World world, double x, double y, double z, EntityLivingBase caster, int lifetime) {
        super(world);
        this.func_70107_b(x, y, z);
        this.caster = new WeakReference<EntityLivingBase>(caster);
        this.field_70728_aV = 0;
        this.lifetime = lifetime;
        this.targetSelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (EntitySummonedCreature.this.isValidTarget(entity)) {
                    if (entity instanceof EntityPlayer) {
                        return true;
                    }
                    if ((entity instanceof IMob || entity instanceof EntitySummonedCreature || entity instanceof EntityWizard && !(EntitySummonedCreature.this.getCaster() instanceof EntityWizard) || Arrays.asList(Wizardry.summonedCreatureTargetsWhitelist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) && !Arrays.asList(Wizardry.summonedCreatureTargetsBlacklist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    public boolean func_70686_a(Class entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType) || this.hasRangedAttack();
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (entity != this.getCaster() || Wizardry.minionRevengeTargeting) {
            super.func_70604_c(entity);
        }
    }

    public abstract boolean hasRangedAttack();

    public void func_70636_d() {
        this.func_82168_bl();
        float f = this.func_70013_c(1.0f);
        if (f > 0.5f) {
            this.field_70708_bq += 2;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        if (this.getCaster() == null && this.casterUUID != null && (entity = WizardryUtilities.getEntityByUUID(this.field_70170_p, this.casterUUID)) instanceof EntityLivingBase) {
            this.caster = new WeakReference<EntityLivingBase>((EntityLivingBase)entity);
        }
        if (this.field_70173_aa == 1) {
            this.onSpawn();
        }
        if (this.field_70173_aa > this.lifetime && this.lifetime != -1) {
            this.despawn();
        }
    }

    public void onSpawn() {
    }

    public void despawn() {
        this.func_70106_y();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected Entity func_70782_k() {
        List<EntityLivingBase> entities = WizardryUtilities.getEntitiesWithinRadius(this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p);
        Entity entity = null;
        for (Entity entity2 : entities) {
            if (entity != null && !(this.func_70032_d(entity) > this.func_70032_d(entity2)) || !this.isValidTarget(entity2) || !this.func_70685_l(entity2)) continue;
            entity = entity2;
        }
        return entity;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (super.func_70097_a(source, par2)) {
            Entity entity = source.func_76346_g();
            if (this.field_70153_n != entity && this.field_70154_o != entity) {
                if (entity != this) {
                    this.field_70789_a = entity;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (target instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            i += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (flag = target.func_70097_a(MagicDamage.causeIndirectEntityMagicDamage((Entity)this, this.getCaster(), MagicDamage.DamageType.MAGIC), f)) {
            int j;
            if (i > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(j * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
        }
        return flag;
    }

    protected void func_70785_a(Entity par1Entity, float par2) {
        if (this.field_70724_aR <= 0 && par2 < 2.0f && par1Entity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && par1Entity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(par1Entity);
        }
    }

    public float func_70783_a(int par1, int par2, int par3) {
        return 0.5f - this.field_70170_p.func_72801_o(par1, par2, par3);
    }

    protected boolean isValidLightLevel() {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72972_b(EnumSkyBlock.Sky, i, j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v)) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int l = this.field_70170_p.func_72957_l(i, j, k);
        if (this.field_70170_p.func_72911_I()) {
            int i1 = this.field_70170_p.field_73008_k;
            this.field_70170_p.field_73008_k = 10;
            l = this.field_70170_p.func_72957_l(i, j, k);
            this.field_70170_p.field_73008_k = i1;
        }
        return l <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.isValidLightLevel() && super.func_70601_bi();
    }

    protected boolean func_70085_c(EntityPlayer player) {
        ExtendedPlayer properties = ExtendedPlayer.get(player);
        if (player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemWand) {
            if (!player.field_70170_p.field_72995_K && properties != null && this.getCaster() == player) {
                properties.selectedMinion = properties.selectedMinion != null && properties.selectedMinion.get() == this ? null : new WeakReference<EntitySummonedCreature>(this);
                properties.sync();
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.getCaster() != null) {
            nbttagcompound.func_74778_a("casterUUID", this.getCaster().func_110124_au().toString());
        }
        nbttagcompound.func_74768_a("lifetime", this.lifetime);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        String string = nbttagcompound.func_74779_i("casterUUID");
        if (WizardryUtilities.verifyUUIDString(string)) {
            this.casterUUID = UUID.fromString(string);
        }
        this.lifetime = nbttagcompound.func_74762_e("lifetime");
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.lifetime);
    }

    public void readSpawnData(ByteBuf data) {
        this.lifetime = data.readInt();
    }

    public EntityLivingBase getCaster() {
        return this.caster == null ? null : (EntityLivingBase)this.caster.get();
    }

    protected void setCaster(EntityLivingBase caster) {
        this.caster = new WeakReference<EntityLivingBase>(caster);
    }

    public boolean isValidTarget(Entity target) {
        return WizardryUtilities.isValidTarget((Entity)this.getCaster(), target);
    }
}

