/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.living;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryRegistry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtTradePlayer;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;

public class EntityWizard
extends EntityVillager
implements IRangedAttackMob,
IEntityAdditionalSpawnData {
    private EntityAIArrowAttack aiArrowAttack = new EntityAIArrowAttack((IRangedAttackMob)this, 0.5, 20, 50, 14.0f);
    public int textureIndex = 0;
    private WeakReference<EntityPlayer> buyingPlayer;
    protected IEntitySelector targetSelector;
    private MerchantRecipeList buyingList;
    private int timeUntilReset;
    private boolean updateRecipes;
    private String lastBuyingPlayer;
    private static final int healCooldownIndex = 20;
    private int[] spells = new int[4];
    private int[][] towerBlocks;

    public EntityWizard(World par1World) {
        super(par1World);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.func_70661_as().func_75498_b(true);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityWizard.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetSelector = new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return entity != null && WizardryUtilities.isValidTarget((Entity)EntityWizard.this, entity) && (entity instanceof IMob || entity instanceof EntitySummonedCreature || Arrays.asList(Wizardry.summonedCreatureTargetsWhitelist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT))) && !Arrays.asList(Wizardry.summonedCreatureTargetsBlacklist).contains(EntityList.func_75621_b((Entity)entity).toLowerCase(Locale.ROOT));
            }
        };
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, this.targetSelector));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiArrowAttack);
        this.func_110177_bN();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        int healCooldown = this.field_70180_af.func_75679_c(20);
        if (healCooldown == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.func_110143_aJ() > 0.0f && !this.func_70644_a(Wizardry.arcaneJammer)) {
            this.func_70691_i(this.func_70946_n() == 7 ? 8.0f : 4.0f);
            this.field_70180_af.func_75692_b(20, (Object)-1);
        } else if (healCooldown == -1 && this.field_70725_aQ == 0) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = (float)this.field_70165_t + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    double d1 = (float)this.field_70163_u - 0.5f + this.field_70146_Z.nextFloat();
                    double d2 = (float)this.field_70161_v + this.field_70146_Z.nextFloat() * 2.0f - 1.0f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, this.field_70170_p, d0, d1, d2, 0.0, 0.1f, 0.0, 48 + this.field_70146_Z.nextInt(12), 1.0f, 1.0f, 0.3f);
                }
            } else {
                if (this.func_110143_aJ() < 10.0f) {
                    this.field_70180_af.func_75692_b(20, (Object)150);
                } else {
                    this.field_70180_af.func_75692_b(20, (Object)400);
                }
                this.field_70170_p.func_72956_a((Entity)this, "wizardry:heal", 0.7f, this.field_70146_Z.nextFloat() * 0.4f + 1.0f);
            }
        }
        if (healCooldown > 0) {
            this.field_70180_af.func_75692_b(20, (Object)(healCooldown - 1));
        }
    }

    public void func_82196_d(EntityLivingBase target, float f) {
        if (f < 30.0f && !this.func_70644_a(Wizardry.arcaneJammer)) {
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = target.field_70161_v - this.field_70161_v;
            if (this.field_70724_aR == 0 && this.spells.length > 0 && !this.field_70170_p.field_72995_K) {
                ArrayList<Spell> spellsArray = new ArrayList<Spell>(this.spells.length);
                for (int i = 0; i < this.spells.length; ++i) {
                    spellsArray.add(Spell.get(this.spells[i]));
                }
                while (!spellsArray.isEmpty()) {
                    Spell spell = (Spell)spellsArray.get(this.field_70146_Z.nextInt(spellsArray.size()));
                    if (spell != null && spell.cast(this.field_70170_p, (EntityLiving)this, target, 1.0f, 1.0f, 1.0f, 1.0f)) {
                        if (spell.doesSpellRequirePacket()) {
                            PacketCastSpell.Message msg = new PacketCastSpell.Message(this.func_145782_y(), target.func_145782_y(), spell.id(), 1.0f, 1.0f, 1.0f);
                            WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.field_70170_p.field_73011_w.field_76574_g);
                        }
                        this.field_70177_z = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                        this.field_70787_b = true;
                        break;
                    }
                    spellsArray.remove(spell);
                }
            }
        }
    }

    protected void func_70629_bd() {
        if (!this.func_70940_q() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.updateRecipes) {
                    if (this.buyingList.size() > 1) {
                        for (MerchantRecipe merchantrecipe : this.buyingList) {
                            if (!merchantrecipe.func_82784_g()) continue;
                            merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                        }
                    }
                    if (this.buyingList.size() < 12) {
                        this.addRandomRecipes(1);
                    }
                    this.updateRecipes = false;
                }
                this.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 200, 0));
            }
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (player.field_71075_bZ.field_75098_d && itemstack != null && itemstack.func_77973_b() instanceof ItemSpellBook && Spell.get(itemstack.func_77960_j()).canBeCastByNPCs()) {
            this.spells[this.field_70146_Z.nextInt((int)3) + 1] = itemstack.func_77960_j();
            return true;
        }
        if (this.func_70089_S() && !this.func_70940_q() && !this.func_70631_g_() && !player.func_70093_af() && this.func_70638_az() != player) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70932_a_(player);
                player.func_71030_a((IMerchant)this, this.getElement().getWizardName());
            }
            return true;
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound tagcompound) {
        super.func_70014_b(tagcompound);
        tagcompound.func_74768_a("Profession", this.func_70946_n());
        tagcompound.func_74768_a("skin", this.textureIndex);
        if (this.buyingList != null) {
            tagcompound.func_74782_a("Offers", (NBTBase)this.buyingList.func_77202_a());
        }
        tagcompound.func_74783_a("spells", this.spells);
        if (this.towerBlocks != null && this.towerBlocks.length > 0) {
            NBTTagList blocks = new NBTTagList();
            for (int[] block : this.towerBlocks) {
                blocks.func_74742_a((NBTBase)new NBTTagIntArray(block));
            }
            tagcompound.func_74782_a("towerBlocks", (NBTBase)blocks);
        }
    }

    public void func_70037_a(NBTTagCompound tagcompound) {
        super.func_70037_a(tagcompound);
        this.func_70938_b(tagcompound.func_74762_e("Profession"));
        this.textureIndex = tagcompound.func_74762_e("skin");
        if (tagcompound.func_74764_b("Offers")) {
            NBTTagCompound nbttagcompound1 = tagcompound.func_74775_l("Offers");
            this.buyingList = new MerchantRecipeList(nbttagcompound1);
        }
        this.spells = tagcompound.func_74759_k("spells");
        NBTTagList blocks = tagcompound.func_150295_c("towerBlocks", 11);
        if (blocks != null) {
            if (this.towerBlocks == null) {
                this.towerBlocks = new int[blocks.func_74745_c()][3];
            }
            for (int i = 0; i < blocks.func_74745_c(); ++i) {
                this.towerBlocks[i] = blocks.func_150306_c(i);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected String func_70639_aQ() {
        return this.func_70940_q() ? "mob.villager.haggle" : "mob.villager.idle";
    }

    protected String func_70621_aR() {
        return "mob.villager.hit";
    }

    protected String func_70673_aS() {
        return "mob.villager.death";
    }

    public EnumElement getElement() {
        return EnumElement.values()[this.func_70946_n()];
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
    }

    public void func_70932_a_(EntityPlayer par1EntityPlayer) {
        this.setBuyingPlayer(par1EntityPlayer);
    }

    public EntityPlayer func_70931_l_() {
        return this.getBuyingPlayer();
    }

    public boolean func_70940_q() {
        return this.getBuyingPlayer() != null;
    }

    public void func_70933_a(MerchantRecipe merchantrecipe) {
        merchantrecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_85030_a("mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
        if (this.getBuyingPlayer() != null) {
            this.getBuyingPlayer().func_71029_a((StatBase)Wizardry.wizardTrade);
            if (merchantrecipe.func_77397_d().func_77973_b() instanceof ItemSpellBook && Spell.get((int)merchantrecipe.func_77397_d().func_77960_j()).tier == EnumTier.MASTER) {
                this.getBuyingPlayer().func_71029_a((StatBase)Wizardry.buyMasterSpell);
            }
        }
        if (this.field_70146_Z.nextInt(5) > 0) {
            this.timeUntilReset = 40;
            this.updateRecipes = true;
            this.lastBuyingPlayer = this.getBuyingPlayer() != null ? this.getBuyingPlayer().func_70005_c_() : null;
        }
    }

    public void func_110297_a_(ItemStack par1ItemStack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            if (par1ItemStack != null) {
                this.func_85030_a("mob.villager.yes", this.func_70599_aP(), this.func_70647_i());
            } else {
                this.func_85030_a("mob.villager.no", this.func_70599_aP(), this.func_70647_i());
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
            ItemStack anySpellBook = new ItemStack(Wizardry.spellBook, 1, Short.MAX_VALUE);
            ItemStack crystalStack = new ItemStack(Wizardry.magicCrystal, 5);
            this.buyingList.add((Object)new MerchantRecipe(anySpellBook, crystalStack));
            this.addRandomRecipes(3);
        }
        return this.buyingList;
    }

    private void addRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            ItemStack itemToSell = null;
            boolean itemAlreadySold = true;
            EnumTier tier = EnumTier.BASIC;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.5 + 0.04 * (double)Math.max(this.buyingList.size() - 4, 0);
                tier = EnumTier.BASIC;
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = EnumTier.APPRENTICE;
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                        tier = EnumTier.ADVANCED;
                        if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                            tier = EnumTier.MASTER;
                        }
                    }
                }
                itemToSell = this.getRandomItemOfTier(tier);
                for (Object recipe : merchantrecipelist) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
                if (this.buyingList == null) continue;
                for (Object recipe : this.buyingList) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
            }
            if (itemToSell == null) {
                return;
            }
            merchantrecipelist.add((Object)new MerchantRecipe(this.getRandomPrice(tier), new ItemStack(Wizardry.magicCrystal, tier.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4)), itemToSell));
        }
        Collections.shuffle(merchantrecipelist);
        if (this.buyingList == null) {
            this.buyingList = new MerchantRecipeList();
        }
        for (int j1 = 0; j1 < merchantrecipelist.size(); ++j1) {
            this.buyingList.add((Object)((MerchantRecipe)merchantrecipelist.get(j1)));
        }
    }

    private ItemStack getRandomPrice(EnumTier tier) {
        ItemStack itemstack = null;
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                itemstack = new ItemStack(Items.field_151043_k, (tier.ordinal() + 1) * 8 - 1 + this.field_70146_Z.nextInt(6));
                break;
            }
            case 1: {
                itemstack = new ItemStack(Items.field_151045_i, (tier.ordinal() + 1) * 4 - 2 + this.field_70146_Z.nextInt(3));
                break;
            }
            case 2: {
                itemstack = new ItemStack(Items.field_151166_bC, (tier.ordinal() + 1) * 6 - 1 + this.field_70146_Z.nextInt(3));
            }
        }
        return itemstack;
    }

    private ItemStack getRandomItemOfTier(EnumTier tier) {
        List<Spell> spells = Spell.getSpells(new Spell.TierElementFilter(tier, null));
        List<Spell> specialismSpells = Spell.getSpells(new Spell.TierElementFilter(tier, this.getElement()));
        switch (tier) {
            case BASIC: {
                int randomiser = this.field_70146_Z.nextInt(5);
                if (randomiser < 4 && !spells.isEmpty()) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(Wizardry.spellBook, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(Wizardry.spellBook, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0) {
                    return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                }
                return new ItemStack(WizardryUtilities.getWand(tier, EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)]));
            }
            case APPRENTICE: {
                int randomiser = this.field_70146_Z.nextInt(Wizardry.discoveryMode ? 12 : 10);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(Wizardry.spellBook, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(Wizardry.spellBook, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(WizardryUtilities.getWand(tier, EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(Wizardry.arcaneTome, 1, 1);
                }
                if (randomiser < 10) {
                    int slot = this.field_70146_Z.nextInt(4);
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getArmour(this.getElement(), slot));
                    }
                    return new ItemStack(WizardryUtilities.getArmour(EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)], slot));
                }
                return new ItemStack(Wizardry.identificationScroll);
            }
            case ADVANCED: {
                int randomiser = this.field_70146_Z.nextInt(12);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(Wizardry.spellBook, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                    }
                    return new ItemStack(Wizardry.spellBook, 1, spells.get(this.field_70146_Z.nextInt(spells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(WizardryUtilities.getWand(tier, EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(Wizardry.arcaneTome, 1, 2);
                }
                randomiser = this.field_70146_Z.nextInt(8);
                switch (randomiser) {
                    case 0: {
                        return new ItemStack(Wizardry.condenserUpgrade);
                    }
                    case 1: {
                        return new ItemStack(Wizardry.siphonUpgrade);
                    }
                    case 2: {
                        return new ItemStack(Wizardry.storageUpgrade);
                    }
                    case 3: {
                        return new ItemStack(Wizardry.rangeUpgrade);
                    }
                    case 4: {
                        return new ItemStack(Wizardry.durationUpgrade);
                    }
                    case 5: {
                        return new ItemStack(Wizardry.cooldownUpgrade);
                    }
                    case 6: {
                        return new ItemStack(Wizardry.blastUpgrade);
                    }
                    case 7: {
                        return new ItemStack(Wizardry.attunementUpgrade);
                    }
                }
            }
            case MASTER: {
                int randomiser;
                int n = randomiser = this.func_70946_n() > 0 ? this.field_70146_Z.nextInt(8) : 5 + this.field_70146_Z.nextInt(3);
                if (randomiser < 5 && this.func_70946_n() > 0 && !specialismSpells.isEmpty()) {
                    return new ItemStack(Wizardry.spellBook, 1, specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size())).id());
                }
                if (randomiser < 6) {
                    if (this.func_70946_n() > 0 && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryUtilities.getWand(tier, this.getElement()));
                    }
                    return new ItemStack(Wizardry.masterWand);
                }
                return new ItemStack(Wizardry.arcaneTome, 1, 3);
            }
        }
        return new ItemStack(Blocks.field_150348_b);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList par1MerchantRecipeList) {
    }

    public IEntityLivingData func_110161_a(IEntityLivingData par1EntityLivingData) {
        par1EntityLivingData = super.func_110161_a(par1EntityLivingData);
        this.textureIndex = this.field_70146_Z.nextInt(6);
        if (this.field_70146_Z.nextBoolean()) {
            this.func_70938_b(this.field_70146_Z.nextInt(EnumElement.values().length - 1) + 1);
        } else {
            this.func_70938_b(0);
        }
        EnumElement e = this.getElement();
        this.func_70062_b(1, new ItemStack(WizardryUtilities.getArmour(e, 3)));
        this.func_70062_b(2, new ItemStack(WizardryUtilities.getArmour(e, 2)));
        this.func_70062_b(3, new ItemStack(WizardryUtilities.getArmour(e, 1)));
        this.func_70062_b(4, new ItemStack(WizardryUtilities.getArmour(e, 0)));
        EnumTier maxTier = EnumTier.BASIC;
        this.func_96120_a(0, 0.0f);
        this.func_96120_a(1, 0.0f);
        this.func_96120_a(2, 0.0f);
        this.func_96120_a(3, 0.0f);
        this.func_96120_a(4, 0.0f);
        this.spells[0] = WizardryRegistry.magicMissile.id();
        List<Spell> npcSpells = Spell.getSpells(Spell.npcSpells);
        for (int i = 1; i < this.spells.length; ++i) {
            int j;
            EnumElement element = e == EnumElement.MAGIC ? EnumElement.values()[this.field_70146_Z.nextInt(EnumElement.values().length)] : e;
            int randomiser = this.field_70146_Z.nextInt(20);
            EnumTier tier = randomiser < 10 ? EnumTier.BASIC : (randomiser < 16 ? EnumTier.APPRENTICE : EnumTier.ADVANCED);
            if (tier.ordinal() > maxTier.ordinal()) {
                maxTier = tier;
            }
            List<Spell> list = Spell.getSpells(new Spell.TierElementFilter(tier, element));
            list.retainAll(npcSpells);
            for (j = 0; j < i; ++j) {
                list.remove(Spell.get(this.spells[j]));
            }
            if (list.isEmpty()) {
                list = npcSpells;
                for (j = 0; j < i; ++j) {
                    list.remove(Spell.get(this.spells[j]));
                }
            }
            if (list.isEmpty()) continue;
            this.spells[i] = list.get(this.field_70146_Z.nextInt(list.size())).id();
        }
        this.func_70062_b(0, new ItemStack(WizardryUtilities.getWand(maxTier, e)));
        return par1EntityLivingData;
    }

    public EntityWizard doSomething(EntityAgeable par1EntityAgeable) {
        EntityWizard entityvillager = new EntityWizard(this.field_70170_p);
        entityvillager.func_110161_a(null);
        return entityvillager;
    }

    public boolean func_110164_bC() {
        return false;
    }

    public EntityVillager func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.doSomething(par1EntityAgeable);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.textureIndex);
    }

    public void readSpawnData(ByteBuf data) {
        this.textureIndex = data.readInt();
    }

    private EntityPlayer getBuyingPlayer() {
        return this.buyingPlayer == null ? null : (EntityPlayer)this.buyingPlayer.get();
    }

    private void setBuyingPlayer(EntityPlayer buyingPlayer) {
        this.buyingPlayer = new WeakReference<EntityPlayer>(buyingPlayer);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            ((EntityPlayer)source.func_76346_g()).func_71029_a((StatBase)Wizardry.angerWizard);
        }
        return super.func_70097_a(source, damage);
    }

    public void setTowerBlocks(int[][] blocks) {
        this.towerBlocks = blocks;
    }

    public boolean isBlockPartOfTower(int x, int y, int z) {
        if (this.towerBlocks == null || this.towerBlocks.length <= 0) {
            return false;
        }
        for (int[] block : this.towerBlocks) {
            if (block == null || block[0] != x || block[1] != y || block[2] != z) continue;
            return true;
        }
        return false;
    }

    public boolean func_70941_o() {
        return false;
    }

    public void func_70947_e(boolean p_70947_1_) {
    }

    public void func_70939_f(boolean p_70939_1_) {
    }

    public boolean func_70945_p() {
        return false;
    }

    public void func_82187_q() {
    }
}

