/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.entity.projectile;

import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EntityIceLance
extends EntityMagicArrow {
    public EntityIceLance(World world) {
        super(world);
        this.setKnockbackStrength(1);
    }

    public EntityIceLance(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.setKnockbackStrength(1);
    }

    public EntityIceLance(World world, EntityLivingBase caster, Entity target, float speed, float aimingError, float damageMultiplier) {
        super(world, caster, target, speed, aimingError, damageMultiplier);
        this.setKnockbackStrength(1);
    }

    public EntityIceLance(World world, EntityLivingBase caster, float speed, float damageMultiplier) {
        super(world, caster, speed, damageMultiplier);
        this.setKnockbackStrength(1);
    }

    @Override
    public void onEntityHit(EntityLivingBase entityHit) {
        if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)entityHit)) {
            entityHit.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, 300, 0, true));
        }
        this.func_85030_a("game.neutral.hurt", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public void tickInAir() {
    }

    @Override
    public void onBlockHit() {
        if (this.field_70170_p.field_72995_K) {
            for (int j = 0; j < 10; ++j) {
                double x = this.field_70165_t - 0.25 + this.field_70146_Z.nextDouble() / 2.0;
                double y = this.field_70163_u - 0.25 + this.field_70146_Z.nextDouble() / 2.0;
                double z = this.field_70161_v - 0.25 + this.field_70146_Z.nextDouble() / 2.0;
                Wizardry.proxy.spawnParticle(EnumParticleType.ICE, this.field_70170_p, x, y, z, x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v, 20 + this.field_70146_Z.nextInt(10));
            }
        }
        this.func_85030_a("game.potion.smash", 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 1.2f);
    }

    @Override
    public void tickInGround() {
        this.func_70106_y();
    }

    @Override
    public double getDamage() {
        return 10.0;
    }

    @Override
    public MagicDamage.DamageType getDamageType() {
        return MagicDamage.DamageType.FROST;
    }

    @Override
    public boolean doGravity() {
        return true;
    }

    @Override
    public boolean doDeceleration() {
        return true;
    }

    @Override
    public boolean doOverpenetration() {
        return true;
    }

    protected void func_70088_a() {
    }

    public boolean func_90999_ad() {
        return false;
    }
}

