/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.ExtendedPlayer;
import electroblob.wizardry.SpellGlyphData;
import electroblob.wizardry.WandHelper;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWand
extends Item {
    public EnumTier tier;
    public EnumElement element;

    public ItemWand(EnumTier enumtier, EnumElement enumelement) {
        this.func_77625_d(1);
        if (enumelement == null || enumtier == EnumTier.BASIC) {
            this.func_77637_a(Wizardry.tabWizardry);
        }
        this.tier = enumtier;
        this.element = enumelement;
        this.func_77656_e(this.tier.maxCharge);
    }

    public boolean func_77662_d() {
        return true;
    }

    public int getMaxDamage(ItemStack itemstack) {
        return (int)((float)this.func_77612_l() * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel(itemstack, Wizardry.storageUpgrade)) + 0.5f);
    }

    public void func_77622_d(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71029_a((StatBase)Wizardry.arcaneInitiate);
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int slot, boolean isHeld) {
        WandHelper.decrementCooldowns(itemstack);
        if (!world.field_72995_K && itemstack.func_77951_h() && world.func_72820_D() % 50L == 0L) {
            itemstack.func_77964_b(itemstack.func_77960_j() - WandHelper.getUpgradeLevel(itemstack, Wizardry.condenserUpgrade));
        }
        if (entity instanceof EntityPlayer && this.element != null && this.element != EnumElement.MAGIC) {
            ((EntityPlayer)entity).func_71029_a((StatBase)Wizardry.elemental);
        }
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return WandHelper.getCurrentSpell((ItemStack)itemstack).action;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List text, boolean par4) {
        if (this.element != null) {
            text.add("\u00a78" + StatCollector.func_74837_a((String)"item.wand.buff", (Object[])new Object[]{(int)((float)(this.tier.level + 1) * 0.15f * 100.0f + 0.5f) + "%", this.element.getDisplayName()}));
        }
        Spell spell = WandHelper.getCurrentSpell(itemstack);
        boolean discovered = true;
        if (Wizardry.discoveryMode && !player.field_71075_bZ.field_75098_d && ExtendedPlayer.get(player) != null && !ExtendedPlayer.get(player).hasSpellBeenDiscovered(spell)) {
            discovered = false;
        }
        text.add("\u00a77" + StatCollector.func_74837_a((String)"item.wand.spell", (Object[])new Object[]{discovered ? "\u00a77" + spell.getDisplayNameWithFormatting() : "#\u00a79" + SpellGlyphData.getGlyphName(spell, player.field_70170_p)}));
        text.add("\u00a79" + StatCollector.func_74837_a((String)"item.wand.mana", (Object[])new Object[]{this.getMaxDamage(itemstack) - this.getDamage(itemstack), this.getMaxDamage(itemstack)}));
    }

    public String func_77653_i(ItemStack p_77653_1_) {
        return ((this.element == null ? "" : this.element.colour) + StatCollector.func_74838_a((String)(this.func_77657_g(p_77653_1_) + ".name"))).trim();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (this.selectMinionTarget(player, world)) {
            return stack;
        }
        if (player.func_70644_a(Wizardry.arcaneJammer)) {
            return stack;
        }
        Spell spell = WandHelper.getCurrentSpell(stack);
        if (!spell.isEnabled()) {
            if (!world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("spell.disabled", new Object[]{spell.getDisplayNameWithFormatting()}));
            }
            return stack;
        }
        if (spell.isContinuous && !player.func_71039_bw()) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        if (!spell.isContinuous && spell.tier.level <= this.tier.level && spell.cost <= stack.func_77958_k() - stack.func_77960_j() && (WandHelper.getCurrentCooldown(stack) == 0 || player.field_71075_bZ.field_75098_d)) {
            float rangeMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.rangeUpgrade) * 0.25f;
            float durationMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.durationUpgrade) * 0.25f;
            float blastMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.blastUpgrade) * 0.25f;
            float damageMultiplier = 1.0f;
            if (this.element == spell.element) {
                damageMultiplier = 1.0f + (float)(this.tier.level + 1) * 0.15f;
            }
            if (!world.field_72995_K) {
                if (spell.cast(world, player, 0, damageMultiplier, rangeMultiplier, durationMultiplier, blastMultiplier)) {
                    if (spell.doesSpellRequirePacket()) {
                        PacketCastSpell.Message msg = new PacketCastSpell.Message(player.func_145782_y(), 0, spell.id(), damageMultiplier, rangeMultiplier, blastMultiplier);
                        WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.field_76574_g);
                    }
                    player.func_71008_a(stack, this.func_77626_a(stack));
                    if (!player.field_71075_bZ.field_75098_d && !ExtendedPlayer.get(player).hasSpellBeenDiscovered(spell) && Wizardry.discoveryMode) {
                        player.field_70170_p.func_72956_a((Entity)player, "random.levelup", 1.25f, 1.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("spell.discover", new Object[]{spell.getDisplayNameWithFormatting()}));
                        }
                    }
                    ExtendedPlayer.get(player).discoverSpell(spell);
                    if (!player.field_71075_bZ.field_75098_d) {
                        float cooldownMultiplier = 1.0f - (float)WandHelper.getUpgradeLevel(stack, Wizardry.cooldownUpgrade) * 0.15f;
                        if (player.func_70644_a(Wizardry.fontOfMana)) {
                            cooldownMultiplier /= (float)(2 + player.func_70660_b(Wizardry.fontOfMana).func_76458_c());
                        }
                        WandHelper.setCurrentCooldown(stack, (int)((float)spell.cooldown * cooldownMultiplier));
                    }
                    int armourPieces = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (player.func_82169_q(i) == null || !(player.func_82169_q(i).func_77973_b() instanceof ItemWizardArmour) || ((ItemWizardArmour)player.func_82169_q((int)i).func_77973_b()).element != spell.element) continue;
                        ++armourPieces;
                    }
                    stack.func_77972_a((int)((float)spell.cost * (1.0f - (float)armourPieces * 0.2f)), (EntityLivingBase)player);
                }
            } else if (!spell.doesSpellRequirePacket() && spell.cast(world, player, 0, damageMultiplier, rangeMultiplier, durationMultiplier, blastMultiplier) && ExtendedPlayer.get(player) != null) {
                ExtendedPlayer.get(player).discoverSpell(spell);
            }
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        Spell spell = WandHelper.getCurrentSpell(stack);
        ExtendedPlayer properties = ExtendedPlayer.get(player);
        if (spell.isContinuous && spell.tier.level <= this.tier.level && spell.cost / 5 <= stack.func_77958_k() - stack.func_77960_j() - properties.damageToApply) {
            float rangeMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.rangeUpgrade) * 0.25f;
            float durationMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.durationUpgrade) * 0.25f;
            float blastMultiplier = 1.0f + (float)WandHelper.getUpgradeLevel(stack, Wizardry.blastUpgrade) * 0.25f;
            float damageMultiplier = 1.0f;
            if (this.element == spell.element) {
                damageMultiplier = 1.0f + (float)(this.tier.level + 1) * 0.15f;
            }
            if (spell.cast(player.field_70170_p, player, stack.func_77988_m() - count, damageMultiplier, rangeMultiplier, durationMultiplier, blastMultiplier)) {
                if (!player.field_71075_bZ.field_75098_d && !properties.hasSpellBeenDiscovered(spell) && Wizardry.discoveryMode) {
                    player.field_70170_p.func_72956_a((Entity)player, "random.levelup", 1.25f, 1.0f);
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("spell.discover", new Object[]{spell.getDisplayNameWithFormatting()}));
                    }
                }
                properties.discoverSpell(spell);
                int tickNumber = count % 20 + 1;
                if (tickNumber % 4 == 1) {
                    int armourPieces = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (player.func_82169_q(i) == null || !(player.func_82169_q(i).func_77973_b() instanceof ItemWizardArmour) || ((ItemWizardArmour)player.func_82169_q((int)i).func_77973_b()).element != spell.element) continue;
                        ++armourPieces;
                    }
                    switch (armourPieces) {
                        case 0: {
                            properties.damageToApply += spell.cost / 5;
                            break;
                        }
                        case 1: {
                            if (tickNumber == 17) break;
                            properties.damageToApply += spell.cost / 5;
                            break;
                        }
                        case 2: {
                            if (tickNumber == 9 || tickNumber == 17) break;
                            properties.damageToApply += spell.cost / 5;
                            break;
                        }
                        case 3: {
                            if (tickNumber == 5 || tickNumber == 13 || tickNumber == 17) break;
                            properties.damageToApply += spell.cost / 5;
                            break;
                        }
                        case 4: {
                            if (tickNumber != 1) break;
                            properties.damageToApply += spell.cost / 5;
                        }
                    }
                }
            }
        }
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityPlayer entityplayer, int par4) {
        ExtendedPlayer properties = ExtendedPlayer.get(entityplayer);
        if (properties.damageToApply <= itemstack.func_77958_k() - itemstack.func_77960_j()) {
            itemstack.func_77972_a(properties.damageToApply, (EntityLivingBase)entityplayer);
        } else {
            itemstack.func_77964_b(itemstack.func_77958_k());
        }
        properties.damageToApply = 0;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        if (player.func_70093_af() && entity instanceof EntityPlayer && ExtendedPlayer.get(player) != null) {
            String string;
            String string2 = string = ExtendedPlayer.get(player).toggleAlly((EntityPlayer)entity) ? "item.wand.addally" : "item.wand.removeally";
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(string, new Object[]{entity.func_70005_c_()}));
            }
            return true;
        }
        return false;
    }

    private boolean selectMinionTarget(EntityPlayer player, World world) {
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)player, 16.0);
        if (rayTrace != null && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntitySummonedCreature minion;
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (player.func_70093_af() && ExtendedPlayer.get(player) != null && ExtendedPlayer.get((EntityPlayer)player).selectedMinion != null && (minion = (EntitySummonedCreature)((Object)ExtendedPlayer.get((EntityPlayer)player).selectedMinion.get())) != null && minion != entity) {
                minion.func_70624_b(entity);
                minion.func_70784_b((Entity)entity);
                ExtendedPlayer.get((EntityPlayer)player).selectedMinion = null;
                return true;
            }
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Wizardry.proxy.getWandDisplayDamage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }
}

