/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Bubble
extends Spell {
    public Bubble() {
        super(EnumTier.APPRENTICE, 15, EnumElement.EARTH, "bubble", EnumSpellType.ATTACK, 20, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        Vec3 look = caster.func_70040_Z();
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)rayTrace.field_72308_g;
            if (!world.field_72995_K) {
                entity.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.MAGIC), 1.0f * damageMultiplier);
                EntityBubble entitybubble = new EntityBubble(world, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (EntityLivingBase)caster, (int)(200.0f * durationMultiplier), false, damageMultiplier);
                world.func_72838_d((Entity)entitybubble);
                entity.func_70078_a((Entity)entitybubble);
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                world.func_72869_a("splash", x1, y1, z1, 0.0, 0.0, 0.0);
                Wizardry.proxy.spawnParticle(EnumParticleType.MAGIC_BUBBLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 0);
            }
        }
        caster.func_71038_i();
        world.func_72956_a((Entity)caster, "game.neutral.swim", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        world.func_72956_a((Entity)caster, "wizardry:ice", 0.5f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!world.field_72995_K) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.MAGIC), 1.0f * damageMultiplier);
                EntityBubble entitybubble = new EntityBubble(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, (EntityLivingBase)caster, (int)(200.0f * durationMultiplier), false, damageMultiplier);
                world.func_72838_d((Entity)entitybubble);
                target.func_70078_a((Entity)entitybubble);
            }
            if (world.field_72995_K) {
                double dx = (target.field_70165_t - caster.field_70165_t) / (double)caster.func_70032_d((Entity)target);
                double dy = (target.field_70163_u - caster.field_70163_u) / (double)caster.func_70032_d((Entity)target);
                double dz = (target.field_70161_v - caster.field_70161_v) / (double)caster.func_70032_d((Entity)target);
                for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                    double x1 = caster.field_70165_t + dx * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + dy * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + dz * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    world.func_72869_a("splash", x1, y1, z1, 0.0, 0.0, 0.0);
                    Wizardry.proxy.spawnParticle(EnumParticleType.MAGIC_BUBBLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 0);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "game.neutral.swim", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
            world.func_72956_a((Entity)caster, "wizardry:ice", 0.5f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

