/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ForestsCurse
extends Spell {
    public ForestsCurse() {
        super(EnumTier.MASTER, 75, EnumElement.EARTH, "forests_curse", EnumSpellType.ATTACK, 200, EnumAction.bow, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(5.0 * (double)blastMultiplier, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target) || MagicDamage.isEntityImmune(MagicDamage.DamageType.POISON, (Entity)target)) continue;
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.POISON), 4.0f * damageMultiplier);
            target.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, (int)(140.0f * durationMultiplier), 2));
            target.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, (int)(140.0f * durationMultiplier), 2));
            target.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, (int)(140.0f * durationMultiplier), 2));
        }
        if (world.field_72995_K) {
            int i = 0;
            while ((float)i < 50.0f * blastMultiplier) {
                double radius = (1.0 + world.field_73012_v.nextDouble() * 4.0) * (double)blastMultiplier;
                double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                float brightness = world.field_73012_v.nextFloat() / 4.0f;
                Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.2, 0.0, 0, 0.05f + brightness, 0.2f + brightness, 0.0f);
                brightness = world.field_73012_v.nextFloat() / 4.0f;
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.05, 0.0, 50, 0.1f + brightness, 0.2f + brightness, 0.0f);
                Wizardry.proxy.spawnParticle(EnumParticleType.LEAF, world, caster.field_70165_t + radius * Math.cos(angle), WizardryUtilities.getPlayerEyesPos(caster) + 0.5, caster.field_70161_v + radius * Math.sin(angle), 0.0, -0.01, 0.0, 40 + world.field_73012_v.nextInt(12));
                ++i;
            }
        }
        world.func_72956_a((Entity)caster, "mob.wither.spawn", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }
}

