/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Freeze
extends Spell {
    public Freeze() {
        super(EnumTier.BASIC, 5, EnumElement.ICE, "freeze", EnumSpellType.ATTACK, 10, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube || target instanceof EntityBlazeMinion) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.FROST), 3.0f * damageMultiplier);
            }
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else {
                target.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, (int)(200.0f * durationMultiplier), 1, true));
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) - WizardryUtilities.getPlayerEyesPos(caster);
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.SNOW, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.02, 0.0, 40 + world.field_73012_v.nextInt(10));
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        rayTrace = WizardryUtilities.rayTrace(10.0f * rangeMultiplier, world, (EntityLivingBase)caster, true);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int blockHitX = rayTrace.field_72311_b;
            int blockHitY = rayTrace.field_72312_c;
            int blockHitZ = rayTrace.field_72309_d;
            int blockHitSide = rayTrace.field_72310_e;
            if (world.func_147439_a(blockHitX, blockHitY, blockHitZ) == Blocks.field_150355_j && !world.field_72995_K) {
                world.func_147449_b(blockHitX, blockHitY, blockHitZ, Blocks.field_150432_aD);
            } else if (world.func_147439_a(blockHitX, blockHitY, blockHitZ) == Blocks.field_150353_l && !world.field_72995_K) {
                world.func_147449_b(blockHitX, blockHitY, blockHitZ, Blocks.field_150343_Z);
            } else if (world.func_147439_a(blockHitX, blockHitY, blockHitZ) == Blocks.field_150356_k && !world.field_72995_K) {
                world.func_147449_b(blockHitX, blockHitY, blockHitZ, Blocks.field_150347_e);
            } else if (blockHitSide == 1 && !world.field_72995_K && world.isSideSolid(blockHitX, blockHitY, blockHitZ, ForgeDirection.UP) && WizardryUtilities.canBlockBeReplaced(world, blockHitX, blockHitY + 1, blockHitZ)) {
                world.func_147449_b(blockHitX, blockHitY + 1, blockHitZ, Blocks.field_150431_aC);
            }
            if (world.field_72995_K) {
                double dx = (double)blockHitX + 0.5 - caster.field_70165_t;
                double dy = (double)blockHitY + 1.5 - (caster.field_70163_u + (double)(caster.field_70131_O / 2.0f));
                double dz = (double)blockHitZ + 0.5 - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), 1.0f, 1.0f, 1.0f);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube || target instanceof EntityBlazeMinion) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.FROST), 3.0f * damageMultiplier);
            }
            if (!world.field_72995_K && !MagicDamage.isEntityImmune(MagicDamage.DamageType.FROST, (Entity)target)) {
                target.func_70690_d(new PotionEffect(Wizardry.frost.field_76415_H, (int)(200.0f * durationMultiplier), 1, true));
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (world.field_72995_K) {
                double dx = target.field_70165_t - caster.field_70165_t;
                double dy = WizardryUtilities.getEntityFeetPos((Entity)target) + (double)(target.field_70131_O / 2.0f) - (caster.field_70163_u + (double)caster.func_70047_e());
                double dz = target.field_70161_v - caster.field_70161_v;
                for (int i = 1; i < 5; ++i) {
                    float brightness = 0.5f + world.field_73012_v.nextFloat() / 2.0f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 1.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.SNOW, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70163_u + (double)caster.func_70047_e() + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.02, 0.0, 40 + world.field_73012_v.nextInt(10));
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

