/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityStatue;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class IceAge
extends Spell {
    private static final int baseDuration = 1200;

    public IceAge() {
        super(EnumTier.MASTER, 70, EnumElement.ICE, "ice_age", EnumSpellType.ATTACK, 250, EnumAction.bow, false);
    }

    @Override
    public boolean doesSpellRequirePacket() {
        return false;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(7.0f * blastMultiplier, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target) || world.field_72995_K) continue;
            if (target instanceof EntityBlaze || target instanceof EntityMagmaCube) {
                // empty if block
            }
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (target instanceof EntityBlaze) {
                caster.func_71064_a((StatBase)Wizardry.freezeBlaze, 1);
            }
            if (!(target instanceof EntityLiving)) continue;
            target.field_70737_aN = 0;
            int x = (int)Math.floor(target.field_70165_t);
            int y = (int)Math.floor(target.field_70163_u);
            int z = (int)Math.floor(target.field_70161_v);
            if (((double)target.field_70131_O < 1.2 || target.func_70631_g_()) && WizardryUtilities.canBlockBeReplaced(world, x, y, z)) {
                world.func_147449_b(x, y, z, Wizardry.iceStatue);
                if (world.func_147438_o(x, y, z) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_147438_o(x, y, z)).setCreatureAndPart((EntityLiving)target, 1, 1);
                    ((TileEntityStatue)world.func_147438_o(x, y, z)).setLifetime((int)(1200.0f * durationMultiplier));
                }
                target.func_70106_y();
                world.func_72956_a((Entity)target, "wizardry:freeze", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                continue;
            }
            if ((double)target.field_70131_O < 2.5 && WizardryUtilities.canBlockBeReplaced(world, x, y, z) && WizardryUtilities.canBlockBeReplaced(world, x, y + 1, z)) {
                world.func_147449_b(x, y, z, Wizardry.iceStatue);
                if (world.func_147438_o(x, y, z) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_147438_o(x, y, z)).setCreatureAndPart((EntityLiving)target, 1, 2);
                    ((TileEntityStatue)world.func_147438_o(x, y, z)).setLifetime((int)(1200.0f * durationMultiplier));
                }
                world.func_147449_b(x, y + 1, z, Wizardry.iceStatue);
                if (world.func_147438_o(x, y + 1, z) instanceof TileEntityStatue) {
                    ((TileEntityStatue)world.func_147438_o(x, y + 1, z)).setCreatureAndPart((EntityLiving)target, 2, 2);
                }
                target.func_70106_y();
                world.func_72956_a((Entity)target, "wizardry:freeze", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                continue;
            }
            if (!WizardryUtilities.canBlockBeReplaced(world, x, y, z) || !WizardryUtilities.canBlockBeReplaced(world, x, y + 1, z) || !WizardryUtilities.canBlockBeReplaced(world, x, y + 2, z)) continue;
            world.func_147449_b(x, y, z, Wizardry.iceStatue);
            if (world.func_147438_o(x, y, z) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_147438_o(x, y, z)).setCreatureAndPart((EntityLiving)target, 1, 3);
                ((TileEntityStatue)world.func_147438_o(x, y, z)).setLifetime((int)(1200.0f * durationMultiplier));
            }
            world.func_147449_b(x, y + 1, z, Wizardry.iceStatue);
            if (world.func_147438_o(x, y + 1, z) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_147438_o(x, y + 1, z)).setCreatureAndPart((EntityLiving)target, 2, 3);
            }
            world.func_147449_b(x, y + 2, z, Wizardry.iceStatue);
            if (world.func_147438_o(x, y + 2, z) instanceof TileEntityStatue) {
                ((TileEntityStatue)world.func_147438_o(x, y + 2, z)).setCreatureAndPart((EntityLiving)target, 3, 3);
            }
            target.func_70106_y();
            world.func_72956_a((Entity)target, "wizardry:freeze", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        }
        if (!world.field_72995_K) {
            for (int i = -7; i < 8; ++i) {
                for (int j = -7; j < 8; ++j) {
                    int y = WizardryUtilities.getNearestFloorLevelB(world, (int)caster.field_70165_t + i, (int)caster.field_70163_u, (int)caster.field_70161_v + j, 7);
                    double dist = caster.func_70011_f((double)((int)caster.field_70165_t + i), (double)y, (double)((int)caster.field_70161_v + j));
                    if (y == -1 || world.field_73012_v.nextInt((int)dist * 2 + 1) >= 7 || !(dist < 8.0)) continue;
                    if (world.func_147439_a((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j) == Blocks.field_150355_j) {
                        world.func_147449_b((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j, Blocks.field_150432_aD);
                        continue;
                    }
                    if (world.func_147439_a((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j) == Blocks.field_150353_l) {
                        world.func_147449_b((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j, Blocks.field_150343_Z);
                        continue;
                    }
                    if (world.func_147439_a((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j) == Blocks.field_150356_k) {
                        world.func_147449_b((int)caster.field_70165_t + i, y - 1, (int)caster.field_70161_v + j, Blocks.field_150347_e);
                        continue;
                    }
                    world.func_147449_b((int)caster.field_70165_t + i, y, (int)caster.field_70161_v + j, Blocks.field_150431_aC);
                }
            }
        }
        world.func_72956_a((Entity)caster, "wizardry:ice", 0.7f, 1.0f);
        world.func_72956_a((Entity)caster, "wizardry:wind", 1.0f, 1.0f);
        return true;
    }
}

