/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LightningRay
extends Spell {
    public LightningRay() {
        super(EnumTier.APPRENTICE, 5, EnumElement.LIGHTNING, "lightning_ray", EnumSpellType.ATTACK, 0, EnumAction.none, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        block9: {
            block12: {
                Entity target;
                block10: {
                    block11: {
                        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier, 2.0f);
                        if (rayTrace == null || rayTrace.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || !(rayTrace.field_72308_g instanceof EntityLivingBase)) break block9;
                        target = rayTrace.field_72308_g;
                        if (world.field_72995_K) break block10;
                        if (ticksInUse % 2 == 0) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                            arc.lifetime = 1;
                            world.func_72838_d((Entity)arc);
                        }
                        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                            if (!world.field_72995_K && ticksInUse == 1) {
                                caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                            }
                        } else {
                            double motionX = target.field_70159_w;
                            double motionY = target.field_70181_x;
                            double motionZ = target.field_70179_y;
                            target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 3.0f * damageMultiplier);
                            target.field_70159_w = motionX;
                            target.field_70181_x = motionY;
                            target.field_70179_y = motionZ;
                        }
                        if (ticksInUse != 1) break block11;
                        world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
                        break block12;
                    }
                    if (ticksInUse <= 0 || ticksInUse % 20 != 0) break block12;
                    world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
                    break block12;
                }
                for (int i = 0; i < 5; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                }
            }
            return true;
        }
        if (!world.field_72995_K && ticksInUse % 2 == 0) {
            EntityArc arc = new EntityArc(world);
            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, caster.field_70165_t + caster.func_70040_Z().field_72450_a * 8.0, caster.field_70163_u + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 8.0, caster.field_70161_v + caster.func_70040_Z().field_72449_c * 8.0);
            arc.lifetime = 1;
            world.func_72838_d((Entity)arc);
        }
        if (ticksInUse == 1) {
            world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
        } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
            world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
        }
        return true;
    }
}

