/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LightningWeb
extends Spell {
    public LightningWeb() {
        super(EnumTier.MASTER, 15, EnumElement.LIGHTNING, "lightning_web", EnumSpellType.ATTACK, 0, EnumAction.none, true);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        block25: {
            Entity target;
            block28: {
                block26: {
                    block27: {
                        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier, 2.0f);
                        if (rayTrace == null || rayTrace.field_72313_a != MovingObjectPosition.MovingObjectType.ENTITY || !(rayTrace.field_72308_g instanceof EntityLivingBase)) break block25;
                        target = rayTrace.field_72308_g;
                        if (world.field_72995_K) break block26;
                        if (ticksInUse % 2 == 0) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
                            arc.lifetime = 1;
                            arc.setOffset(caster.func_70040_Z().field_72449_c * 0.5, caster.func_70040_Z().field_72450_a * 0.5);
                            world.func_72838_d((Entity)arc);
                        }
                        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, target)) {
                            if (!world.field_72995_K && ticksInUse == 1) {
                                caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                            }
                        } else {
                            double motionX = target.field_70159_w;
                            double motionY = target.field_70181_x;
                            double motionZ = target.field_70179_y;
                            target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 5.0f * damageMultiplier);
                            target.field_70159_w = motionX;
                            target.field_70181_x = motionY;
                            target.field_70179_y = motionZ;
                        }
                        if (ticksInUse != 1) break block27;
                        world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
                        break block28;
                    }
                    if (ticksInUse <= 0 || ticksInUse % 20 != 0) break block28;
                    world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
                    break block28;
                }
                for (int i = 0; i < 5; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, target.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)(target.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, target.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                }
            }
            double seekerRange = 5.0;
            List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, world);
            secondaryTargets.remove(target);
            if (secondaryTargets.size() > 5) {
                secondaryTargets = secondaryTargets.subList(0, 5);
            }
            for (EntityLivingBase secondaryTarget : secondaryTargets) {
                block31: {
                    block29: {
                        block30: {
                            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                            if (world.field_72995_K) break block29;
                            if (ticksInUse % 2 == 0) {
                                EntityArc arc = new EntityArc(world);
                                arc.setEndpointCoords(target.field_70165_t, target.field_70163_u + 1.2, target.field_70161_v, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                                arc.lifetime = 1;
                                world.func_72838_d((Entity)arc);
                            }
                            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)secondaryTarget)) {
                                if (!world.field_72995_K && ticksInUse == 1) {
                                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{secondaryTarget.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                                }
                            } else {
                                double motionX = secondaryTarget.field_70159_w;
                                double motionY = secondaryTarget.field_70181_x;
                                double motionZ = secondaryTarget.field_70179_y;
                                secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 4.0f * damageMultiplier);
                                secondaryTarget.field_70159_w = motionX;
                                secondaryTarget.field_70181_x = motionY;
                                secondaryTarget.field_70179_y = motionZ;
                            }
                            if (ticksInUse != 1) break block30;
                            world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
                            break block31;
                        }
                        if (ticksInUse <= 0 || ticksInUse % 20 != 0) break block31;
                        world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
                        break block31;
                    }
                    for (int i = 0; i < 5; ++i) {
                        Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)secondaryTarget) + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    }
                }
                List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                tertiaryTargets.remove(target);
                tertiaryTargets.removeAll(secondaryTargets);
                if (tertiaryTargets.size() > 2) {
                    tertiaryTargets = tertiaryTargets.subList(0, 2);
                }
                for (EntityLivingBase tertiaryTarget : tertiaryTargets) {
                    if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                    if (!world.field_72995_K) {
                        if (ticksInUse % 2 == 0) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + 1.2, secondaryTarget.field_70161_v, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                            arc.lifetime = 1;
                            world.func_72838_d((Entity)arc);
                        }
                        if (MagicDamage.isEntityImmune(MagicDamage.DamageType.SHOCK, (Entity)tertiaryTarget)) {
                            if (!world.field_72995_K && ticksInUse == 1) {
                                caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{tertiaryTarget.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                            }
                        } else {
                            double motionX = tertiaryTarget.field_70159_w;
                            double motionY = tertiaryTarget.field_70181_x;
                            double motionZ = tertiaryTarget.field_70179_y;
                            tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 3.0f * damageMultiplier);
                            tertiaryTarget.field_70159_w = motionX;
                            tertiaryTarget.field_70181_x = motionY;
                            tertiaryTarget.field_70179_y = motionZ;
                        }
                        if (ticksInUse == 1) {
                            world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
                            continue;
                        }
                        if (ticksInUse <= 0 || ticksInUse % 20 != 0) continue;
                        world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
                        continue;
                    }
                    for (int i = 0; i < 5; ++i) {
                        Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)tertiaryTarget) + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                    }
                }
            }
            return true;
        }
        if (!world.field_72995_K && ticksInUse % 2 == 0) {
            EntityArc arc = new EntityArc(world);
            arc.setEndpointCoords(caster.field_70165_t, caster.field_70163_u + 1.2, caster.field_70161_v, caster.field_70165_t + caster.func_70040_Z().field_72450_a * 8.0, caster.field_70163_u + (double)caster.eyeHeight + caster.func_70040_Z().field_72448_b * 8.0, caster.field_70161_v + caster.func_70040_Z().field_72449_c * 8.0);
            arc.lifetime = 1;
            world.func_72838_d((Entity)arc);
        }
        if (ticksInUse == 1) {
            world.func_72956_a((Entity)caster, "wizardry:electricitya", 1.0f, 1.0f);
        } else if (ticksInUse > 0 && ticksInUse % 20 == 0) {
            world.func_72956_a((Entity)caster, "wizardry:electricityb", 1.0f, 1.0f);
        }
        return true;
    }
}

