/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class MindControl
extends Spell {
    public static final String NBT_KEY = "controllingEntity";

    public MindControl() {
        super(EnumTier.ADVANCED, 40, EnumElement.NECROMANCY, "mind_control", EnumSpellType.ATTACK, 150, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        block5: {
            Entity target;
            block8: {
                block6: {
                    NBTTagCompound entityNBT;
                    block7: {
                        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 8.0f * rangeMultiplier);
                        if (rayTrace == null || rayTrace.field_72308_g == null || !(rayTrace.field_72308_g instanceof EntityLivingBase)) break block5;
                        target = rayTrace.field_72308_g;
                        if (world.field_72995_K) break block6;
                        if (!(target instanceof EntityPlayer) && !(target instanceof IBossDisplayData) && !(target instanceof INpc)) break block7;
                        if (!world.field_72995_K) {
                            caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                        }
                        break block8;
                    }
                    if (!(target instanceof EntityLiving)) break block8;
                    if (!MindControl.findMindControlTarget((EntityLiving)target, (EntityLivingBase)caster, world)) {
                        ((EntityLiving)target).func_70624_b(null);
                        if (target instanceof EntityCreature) {
                            ((EntityCreature)target).func_70784_b(null);
                        }
                    }
                    if ((entityNBT = target.getEntityData()) != null) {
                        entityNBT.func_74778_a(NBT_KEY, caster.func_110124_au().toString());
                    }
                    ((EntityLiving)target).func_70690_d(new PotionEffect(Wizardry.mindControl.field_76415_H, (int)(600.0f * durationMultiplier), 0));
                    break block8;
                }
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, WizardryUtilities.getEntityFeetPos(target) + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.2f, 0.04f, 0.25f);
                }
            }
            world.func_72956_a(target, "wizardry:darkaura", 1.0f, 1.0f);
            caster.func_71038_i();
            return true;
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!world.field_72995_K) {
                if (target instanceof EntityLiving && !(target instanceof IBossDisplayData) && !(target instanceof EntityWizard)) {
                    NBTTagCompound entityNBT;
                    if (!MindControl.findMindControlTarget((EntityLiving)target, (EntityLivingBase)caster, world)) {
                        ((EntityLiving)target).func_70624_b(null);
                        if (target instanceof EntityCreature) {
                            ((EntityCreature)target).func_70784_b(null);
                        }
                    }
                    if ((entityNBT = target.getEntityData()) != null) {
                        entityNBT.func_74778_a(NBT_KEY, caster.func_110124_au().toString());
                    }
                    ((EntityLiving)target).func_70690_d(new PotionEffect(Wizardry.mindControl.field_76415_H, (int)(600.0f * durationMultiplier), 0));
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, WizardryUtilities.getEntityFeetPos((Entity)target) + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.8f, 0.2f, 1.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, target.field_70165_t - 0.25 + world.field_73012_v.nextDouble() * 0.5, WizardryUtilities.getEntityFeetPos((Entity)target) + (double)target.func_70047_e() - 0.25 + world.field_73012_v.nextDouble() * 0.5, target.field_70161_v - 0.25 + world.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0, 0, 0.2f, 0.04f, 0.25f);
                }
            }
            world.func_72956_a((Entity)target, "wizardry:darkaura", 1.0f, 1.0f);
            caster.func_71038_i();
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }

    public static boolean findMindControlTarget(EntityLiving target, EntityLivingBase caster, World world) {
        List<EntityLivingBase> possibleTargets = WizardryUtilities.getEntitiesWithinRadius(target.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e(), target.field_70165_t, target.field_70163_u, target.field_70161_v, world);
        possibleTargets.remove(target);
        EntityLivingBase newAITarget = null;
        for (EntityLivingBase possibleTarget : possibleTargets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)possibleTarget) || newAITarget != null && !(target.func_70032_d((Entity)possibleTarget) < target.func_70032_d((Entity)newAITarget))) continue;
            newAITarget = possibleTarget;
        }
        if (newAITarget != null) {
            if (target instanceof EntityCreature) {
                ((EntityCreature)target).func_70784_b(newAITarget);
            }
            target.func_70624_b(newAITarget);
            return true;
        }
        return false;
    }
}

