/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Poison
extends Spell {
    public Poison() {
        super(EnumTier.APPRENTICE, 10, EnumElement.EARTH, "poison", EnumSpellType.ATTACK, 20, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        Vec3 look = caster.func_70040_Z();
        MovingObjectPosition rayTrace = WizardryUtilities.standardEntityRayTrace(world, (EntityLivingBase)caster, 10.0f * rangeMultiplier);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && rayTrace.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
            if (MagicDamage.isEntityImmune(MagicDamage.DamageType.POISON, (Entity)target)) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((IChatComponent)new ChatComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getDisplayNameWithFormatting()}));
                }
            } else {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.POISON), 1.0f * damageMultiplier);
                target.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, (int)(200.0f * durationMultiplier), 1));
            }
        }
        if (world.field_72995_K) {
            for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                double x1 = caster.field_70165_t + look.field_72450_a * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double y1 = WizardryUtilities.getPlayerEyesPos(caster) - (double)0.4f + look.field_72448_b * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                double z1 = caster.field_70161_v + look.field_72449_c * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.3f, 0.7f, 0.0f);
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.1f, 0.4f, 0.0f);
            }
        }
        caster.func_71038_i();
        world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EntityLivingBase target, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (target != null) {
            if (!MagicDamage.isEntityImmune(MagicDamage.DamageType.POISON, (Entity)target) && !world.field_72995_K) {
                target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.POISON), 1.0f * damageMultiplier);
                target.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, (int)(200.0f * durationMultiplier), 1));
            }
            if (world.field_72995_K) {
                double dx = (target.field_70165_t - caster.field_70165_t) / (double)caster.func_70032_d((Entity)target);
                double dy = (target.field_70163_u - caster.field_70163_u) / (double)caster.func_70032_d((Entity)target);
                double dz = (target.field_70161_v - caster.field_70161_v) / (double)caster.func_70032_d((Entity)target);
                for (int i = 1; i < (int)(25.0f * rangeMultiplier); i += 2) {
                    double x1 = caster.field_70165_t + dx * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double y1 = caster.field_70163_u + (double)caster.func_70047_e() - (double)0.4f + dy * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    double z1 = caster.field_70161_v + dz * (double)i / 2.0 + (double)(world.field_73012_v.nextFloat() / 5.0f) - (double)0.1f;
                    Wizardry.proxy.spawnParticle(EnumParticleType.DARK_MAGIC, world, x1, y1, z1, 0.0, 0.0, 0.0, 0, 0.3f, 0.7f, 0.0f);
                    Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, x1, y1, z1, 0.0, 0.0, 0.0, 12 + world.field_73012_v.nextInt(8), 0.1f, 0.4f, 0.0f);
                }
            }
            caster.func_71038_i();
            world.func_72956_a((Entity)caster, "wizardry:ice", 1.0f, world.field_73012_v.nextFloat() * 0.2f + 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeCastByNPCs() {
        return true;
    }
}

