/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.world.World;

public class Shockwave
extends Spell {
    public Shockwave() {
        super(EnumTier.MASTER, 65, EnumElement.SORCERY, "shockwave", EnumSpellType.ATTACK, 150, EnumAction.bow, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        List<EntityLivingBase> targets = WizardryUtilities.getEntitiesWithinRadius(5.0 * (double)blastMultiplier, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, world);
        for (EntityLivingBase target : targets) {
            if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)target)) continue;
            float damage = Math.min(8.0f / target.func_70032_d((Entity)caster), 8.0f);
            target.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.BLAST), damage * damageMultiplier);
            if (world.field_72995_K) continue;
            double velocityFactor = Math.min(5.0 / target.func_70068_e((Entity)caster), 3.0);
            double dx = target.field_70165_t - caster.field_70165_t;
            double dy = target.field_70163_u + 1.0 - caster.field_70163_u;
            double dz = target.field_70161_v - caster.field_70161_v;
            target.field_70159_w = velocityFactor * dx;
            target.field_70181_x = velocityFactor * dy;
            target.field_70179_y = velocityFactor * dz;
            if (!(target instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)target));
        }
        if (world.field_72995_K) {
            world.func_72869_a("largeexplode", caster.field_70165_t, caster.field_70121_D.field_72338_b + 0.1, caster.field_70161_v, 0.0, 0.0, 0.0);
            for (int i = 0; i < 40; ++i) {
                double particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                double particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 30, 0.8f, 0.8f, 1.0f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, 30, 0.9f, 0.9f, 0.9f);
                particleX = caster.field_70165_t - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                particleZ = caster.field_70161_v - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                Block block = WizardryUtilities.getBlockEntityIsStandingOn((Entity)caster);
                if (block == null) continue;
                Wizardry.proxy.spawnDigParticle(world, particleX, WizardryUtilities.getPlayerEyesPos(caster) - 1.5, particleZ, particleX - caster.field_70165_t, 0.0, particleZ - caster.field_70161_v, block);
            }
        }
        caster.func_71038_i();
        world.func_72956_a((Entity)caster, "wizardry:boom", 1.0f, 0.7f);
        world.func_72956_a((Entity)caster, "wizardry:boom", 2.0f, 0.3f);
        return true;
    }
}

