/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Snare
extends Spell {
    public Snare() {
        super(EnumTier.BASIC, 10, EnumElement.EARTH, "snare", EnumSpellType.ATTACK, 10, EnumAction.none, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        MovingObjectPosition rayTrace = WizardryUtilities.rayTrace(10.0f * rangeMultiplier, world, (EntityLivingBase)caster, true);
        if (rayTrace != null && rayTrace.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int blockHitX = rayTrace.field_72311_b;
            int blockHitY = rayTrace.field_72312_c;
            int blockHitZ = rayTrace.field_72309_d;
            int blockHitSide = rayTrace.field_72310_e;
            if (blockHitSide == 1 && world.isSideSolid(blockHitX, blockHitY, blockHitZ, ForgeDirection.UP) && WizardryUtilities.canBlockBeReplaced(world, blockHitX, blockHitY + 1, blockHitZ)) {
                if (!world.field_72995_K) {
                    world.func_147449_b(blockHitX, blockHitY + 1, blockHitZ, Wizardry.snare);
                    ((TileEntityPlayerSave)world.func_147438_o(blockHitX, blockHitY + 1, blockHitZ)).setCaster((EntityLivingBase)caster);
                }
                double dx = (double)blockHitX + 0.5 - caster.field_70165_t;
                double dy = (double)blockHitY + 1.5 - (caster.field_70163_u + (double)(caster.field_70131_O / 2.0f));
                double dz = (double)blockHitZ + 0.5 - caster.field_70161_v;
                if (world.field_72995_K) {
                    for (int i = 1; i < 5; ++i) {
                        float brightness = world.field_73012_v.nextFloat() / 4.0f;
                        Wizardry.proxy.spawnParticle(EnumParticleType.SPARKLE, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, 0.0, 0.0, 20 + world.field_73012_v.nextInt(8), brightness, brightness + 0.1f, 0.0f);
                        Wizardry.proxy.spawnParticle(EnumParticleType.LEAF, world, caster.field_70165_t + (double)i * (dx / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), WizardryUtilities.getPlayerEyesPos(caster) + (double)i * (dy / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), caster.field_70161_v + (double)i * (dz / 5.0) + (double)(world.field_73012_v.nextFloat() / 5.0f), 0.0, -0.01, 0.0, 40 + world.field_73012_v.nextInt(10));
                    }
                }
                caster.func_71038_i();
                world.func_72956_a((Entity)caster, "dig.grass", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.2f);
                return true;
            }
        }
        return false;
    }
}

