/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.EnumElement;
import electroblob.wizardry.EnumParticleType;
import electroblob.wizardry.EnumSpellType;
import electroblob.wizardry.EnumTier;
import electroblob.wizardry.MagicDamage;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.WizardryUtilities;
import electroblob.wizardry.entity.EntityArc;
import electroblob.wizardry.spell.Spell;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.world.World;

public class Thunderstorm
extends Spell {
    public Thunderstorm() {
        super(EnumTier.MASTER, 100, EnumElement.LIGHTNING, "thunderstorm", EnumSpellType.ATTACK, 250, EnumAction.bow, false);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, int ticksInUse, float damageMultiplier, float rangeMultiplier, float durationMultiplier, float blastMultiplier) {
        if (world.func_72937_j((int)caster.field_70165_t, (int)caster.field_70163_u, (int)caster.field_70161_v)) {
            for (int r = 0; r < 10; ++r) {
                double radius = 4.0 + world.field_73012_v.nextDouble() * 6.0 * (double)blastMultiplier;
                double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
                double x = caster.field_70165_t + radius * Math.cos(angle);
                double z = caster.field_70161_v + radius * Math.sin(angle);
                double y = WizardryUtilities.getNearestFloorLevel(world, (int)x, (int)caster.field_70163_u, (int)z, 10);
                if (!world.field_72995_K) {
                    EntityLightningBolt entitylightning = new EntityLightningBolt(world, x, y, z);
                    world.func_72942_c((Entity)entitylightning);
                }
                double seekerRange = 10.0;
                List<EntityLivingBase> secondaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, x, y + 1.0, z, world);
                for (EntityLivingBase secondaryTarget : secondaryTargets) {
                    if (!WizardryUtilities.isValidTarget((Entity)caster, (Entity)secondaryTarget)) continue;
                    if (!world.field_72995_K) {
                        EntityArc arc = new EntityArc(world);
                        arc.setEndpointCoords(x, y + 1.0, z, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v);
                        world.func_72838_d((Entity)arc);
                    } else {
                        for (int j = 0; j < 8; ++j) {
                            Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)secondaryTarget) + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                            world.func_72869_a("largesmoke", secondaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)secondaryTarget) + (double)(secondaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, secondaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                        }
                    }
                    world.func_72956_a((Entity)secondaryTarget, "wizardry:arc", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    secondaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 10.0f * damageMultiplier);
                    List<EntityLivingBase> tertiaryTargets = WizardryUtilities.getEntitiesWithinRadius(seekerRange, secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, world);
                    for (int j = 0; j < Math.min(tertiaryTargets.size(), 3); ++j) {
                        EntityLivingBase tertiaryTarget = tertiaryTargets.get(j);
                        if (secondaryTargets.contains(tertiaryTarget) || !WizardryUtilities.isValidTarget((Entity)caster, (Entity)tertiaryTarget)) continue;
                        if (!world.field_72995_K) {
                            EntityArc arc = new EntityArc(world);
                            arc.setEndpointCoords(secondaryTarget.field_70165_t, secondaryTarget.field_70163_u + (double)(secondaryTarget.field_70131_O / 2.0f), secondaryTarget.field_70161_v, tertiaryTarget.field_70165_t, tertiaryTarget.field_70163_u + (double)(tertiaryTarget.field_70131_O / 2.0f), tertiaryTarget.field_70161_v);
                            world.func_72838_d((Entity)arc);
                        } else {
                            for (int k = 0; k < 8; ++k) {
                                Wizardry.proxy.spawnParticle(EnumParticleType.SPARK, world, tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)tertiaryTarget) + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0, 3);
                                world.func_72869_a("largesmoke", tertiaryTarget.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5, WizardryUtilities.getEntityFeetPos((Entity)tertiaryTarget) + (double)(tertiaryTarget.field_70131_O / 2.0f) + (double)(world.field_73012_v.nextFloat() * 2.0f) - 1.0, tertiaryTarget.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                            }
                        }
                        world.func_72956_a((Entity)tertiaryTarget, "wizardry:arc", 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                        tertiaryTarget.func_70097_a(MagicDamage.causeDirectMagicDamage((EntityLivingBase)caster, MagicDamage.DamageType.SHOCK), 8.0f * damageMultiplier);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

