/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.client.gui;

import com.kenymylankca.enhancedarmaments.EnhancedArmaments;
import com.kenymylankca.enhancedarmaments.config.Config;
import com.kenymylankca.enhancedarmaments.essentials.Ability;
import com.kenymylankca.enhancedarmaments.essentials.Experience;
import com.kenymylankca.enhancedarmaments.essentials.Rarity;
import com.kenymylankca.enhancedarmaments.network.PacketGuiAbility;
import com.kenymylankca.enhancedarmaments.util.EAUtils;
import com.kenymylankca.enhancedarmaments.util.NBTHelper;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiAbilitySelection
extends GuiScreen {
    private GuiButton[] weaponAbilities;
    private GuiButton[] armorAbilities;

    @SideOnly(value=Side.CLIENT)
    public void func_73866_w_() {
        block8: {
            ItemStack stack;
            block9: {
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                if (player == null || (stack = player.field_71071_by.func_70448_g()) == null) break block8;
                if (!EAUtils.canEnhanceWeapon(stack.func_77973_b())) break block9;
                this.weaponAbilities = new GuiButton[Ability.WEAPON_ABILITIES_COUNT];
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) break block8;
                int j = 0;
                for (int i = 0; i < this.weaponAbilities.length; ++i) {
                    if (Ability.WEAPON_ABILITIES.get(i).getType().equals("active")) {
                        this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 215, 100 + i * 21, 110, 20, I18n.func_135052_a((String)("enhancedarmaments.ability." + Ability.WEAPON_ABILITIES.get(i).getName()), (Object[])new Object[0]));
                        ++j;
                    } else {
                        this.weaponAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 100, 100 + (i - j) * 21, 110, 20, I18n.func_135052_a((String)("enhancedarmaments.ability." + Ability.WEAPON_ABILITIES.get(i).getName()), (Object[])new Object[0]));
                    }
                    this.field_146292_n.add(this.weaponAbilities[i]);
                    this.weaponAbilities[i].field_146124_l = false;
                }
                break block8;
            }
            if (EAUtils.canEnhanceArmor(stack.func_77973_b())) {
                this.armorAbilities = new GuiButton[Ability.ARMOR_ABILITIES_COUNT];
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null) {
                    int j = 0;
                    for (int i = 0; i < this.armorAbilities.length; ++i) {
                        if (Ability.ARMOR_ABILITIES.get(i).getType().equals("active")) {
                            this.armorAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 215, 100 + i * 21, 100, 20, I18n.func_135052_a((String)("enhancedarmaments.ability." + Ability.ARMOR_ABILITIES.get(i).getName()), (Object[])new Object[0]));
                            ++j;
                        } else {
                            this.armorAbilities[i] = new GuiButton(i, this.field_146294_l / 2 - 100, 100 + (i - j) * 21, 105, 20, I18n.func_135052_a((String)("enhancedarmaments.ability." + Ability.ARMOR_ABILITIES.get(i).getName()), (Object[])new Object[0]));
                        }
                        this.field_146292_n.add(this.armorAbilities[i]);
                        this.armorAbilities[i].field_146124_l = false;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        NBTTagCompound nbt;
        ItemStack stack;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        if (player != null && (stack = player.field_71071_by.func_70448_g()) != null && EAUtils.canEnhance(stack.func_77973_b()) && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
            if (EAUtils.canEnhanceWeapon(stack.func_77973_b())) {
                this.drawStrings(stack, Ability.WEAPON_ABILITIES, nbt);
                this.displayButtons(this.weaponAbilities, Ability.WEAPON_ABILITIES, nbt, (EntityPlayer)player);
                this.drawTooltips(this.weaponAbilities, Ability.WEAPON_ABILITIES, mouseX, mouseY);
            } else if (EAUtils.canEnhanceArmor(stack.func_77973_b())) {
                this.drawStrings(stack, Ability.ARMOR_ABILITIES, nbt);
                this.displayButtons(this.armorAbilities, Ability.ARMOR_ABILITIES, nbt, (EntityPlayer)player);
                this.drawTooltips(this.armorAbilities, Ability.ARMOR_ABILITIES, mouseX, mouseY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146284_a(GuiButton button) throws IOException {
        block2: {
            ItemStack stack;
            block3: {
                NBTTagCompound nbt;
                EntityPlayerSP player = this.field_146297_k.field_71439_g;
                if (player == null || (stack = player.field_71071_by.func_70448_g()) == null || (nbt = NBTHelper.loadStackNBT(stack)) == null || Experience.getAbilityTokens(nbt) <= 0 && player.field_71068_ca <= 1 && !player.func_184812_l_()) break block2;
                if (!EAUtils.canEnhanceWeapon(stack.func_77973_b())) break block3;
                for (int i = 0; i < this.weaponAbilities.length; ++i) {
                    if (button != this.weaponAbilities[i]) continue;
                    EnhancedArmaments.network.sendToServer((IMessage)new PacketGuiAbility(i));
                }
                break block2;
            }
            if (!EAUtils.canEnhanceArmor(stack.func_77973_b())) break block2;
            for (int i = 0; i < this.armorAbilities.length; ++i) {
                if (button != this.armorAbilities[i]) continue;
                EnhancedArmaments.network.sendToServer((IMessage)new PacketGuiAbility(i));
            }
        }
    }

    private void drawStrings(ItemStack stack, ArrayList<Ability> abilities, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        this.func_73732_a(this.field_146289_q, stack.func_82833_r(), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"enhancedarmaments.misc.rarity", (Object[])new Object[0]) + ": ", this.field_146294_l / 2 - 50, 40, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)("enhancedarmaments.rarity." + rarity.getName()), (Object[])new Object[0]), this.field_146294_l / 2 - 15, 40, rarity.getHex());
        this.func_73732_a(this.field_146289_q, TextFormatting.ITALIC + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 73, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, TextFormatting.GRAY + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities.tokens", (Object[])new Object[0]) + ": " + TextFormatting.DARK_GREEN + Experience.getAbilityTokens(nbt), this.field_146294_l / 2 - 100, 86, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, TextFormatting.GOLD + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities.purchased", (Object[])new Object[0]), this.field_146294_l / 2 + 112, 100, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, TextFormatting.BOLD + I18n.func_135052_a((String)"enhancedarmaments.ability.type.active", (Object[])new Object[0]), this.field_146294_l / 2 + 75, 120, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, TextFormatting.BOLD + I18n.func_135052_a((String)"enhancedarmaments.ability.type.passive", (Object[])new Object[0]), this.field_146294_l / 2 + 150, 120, 0xFFFFFF);
        if (Experience.getLevel(nbt) == Config.maxLevel) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + Experience.getLevel(nbt) + TextFormatting.DARK_RED + " (" + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + ")", this.field_146294_l / 2 - 50, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + Experience.getExperience(nbt), this.field_146294_l / 2 - 50, 60, 0xFFFFFF);
        } else {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + Experience.getLevel(nbt), this.field_146294_l / 2 - 50, 50, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + Experience.getExperience(nbt) + " / " + Experience.getMaxLevelExp(Experience.getLevel(nbt)), this.field_146294_l / 2 - 50, 60, 0xFFFFFF);
        }
        int j = -1;
        int k = -1;
        for (int i = 0; i < abilities.size(); ++i) {
            if (!abilities.get(i).hasAbility(nbt)) continue;
            if (abilities.get(i).getType().equals("active")) {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)abilities.get(i).getName(nbt), (Object[])new Object[0]), this.field_146294_l / 2 + 75, 135 + ++j * 12, abilities.get(i).getHex());
                continue;
            }
            if (!abilities.get(i).getType().equals("passive")) continue;
            this.func_73732_a(this.field_146289_q, abilities.get(i).getName(nbt), this.field_146294_l / 2 + 150, 135 + ++k * 12, abilities.get(i).getHex());
        }
    }

    private void displayButtons(GuiButton[] buttons, ArrayList<Ability> abilities, NBTTagCompound nbt, EntityPlayer player) {
        int i;
        for (i = 0; i < buttons.length; ++i) {
            buttons[i].field_146124_l = false;
        }
        for (i = 0; i < buttons.length; ++i) {
            if (!abilities.get(i).hasAbility(nbt)) {
                if (!abilities.get(i).hasEnoughExp(player, nbt)) continue;
                buttons[i].field_146124_l = true;
                continue;
            }
            buttons[i].field_146124_l = abilities.get(i).canUpgradeLevel(nbt) && Experience.getAbilityTokens(nbt) >= abilities.get(i).getTier();
        }
    }

    private void drawTooltips(GuiButton[] buttons, ArrayList<Ability> abilities, int mouseX, int mouseY) {
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        ItemStack stack = player.field_71071_by.func_70448_g();
        NBTTagCompound nbt = stack.func_77978_p();
        for (int i = 0; i < buttons.length; ++i) {
            float nextlevelduration;
            float currentduration;
            HoverChecker checker = new HoverChecker(buttons[i], 0);
            if (!checker.checkHover(mouseX, mouseY)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(abilities.get(i).getColor() + I18n.func_135052_a((String)("enhancedarmaments.ability." + abilities.get(i).getName()), (Object[])new Object[0]) + " (" + abilities.get(i).getTypeName() + abilities.get(i).getColor() + ")");
            list.add("");
            list.add(I18n.func_135052_a((String)("enhancedarmaments.abilities.info." + abilities.get(i).getName()), (Object[])new Object[0]));
            list.add("");
            if (EAUtils.canEnhanceWeapon(stack.func_77973_b())) {
                int c;
                float chance;
                if (i == 0) {
                    chance = (float)(1.0 / (double)Config.firechance) * 100.0f;
                    currentduration = (Ability.FIRE.getLevel(nbt) + Ability.FIRE.getLevel(nbt) * 4) / 4;
                    nextlevelduration = (Ability.FIRE.getLevel(nbt) + 1 + (Ability.FIRE.getLevel(nbt) + 1) * 4) / 4;
                    c = (int)chance;
                    if (!Ability.FIRE.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.FIRE.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 1) {
                    chance = (float)(1.0 / (double)Config.frostchance) * 100.0f;
                    currentduration = (Ability.FROST.getLevel(nbt) + Ability.FROST.getLevel(nbt) * 4) / 3;
                    nextlevelduration = (Ability.FROST.getLevel(nbt) + 1 + (Ability.FROST.getLevel(nbt) + 1) * 4) / 3;
                    c = (int)chance;
                    if (!Ability.FROST.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.FROST.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 2) {
                    chance = (float)(1.0 / (double)Config.poisonchance) * 100.0f;
                    currentduration = (Ability.POISON.getLevel(nbt) + Ability.POISON.getLevel(nbt) * 4) / 2;
                    nextlevelduration = (Ability.POISON.getLevel(nbt) + 1 + (Ability.POISON.getLevel(nbt) + 1) * 4) / 2;
                    c = (int)chance;
                    if (!Ability.POISON.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.POISON.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 3) {
                    float currentduration2 = (float)Ability.INNATE.getLevel(nbt) * 1.6f;
                    float nextlevelduration2 = (float)(Ability.INNATE.getLevel(nbt) + 1) * 1.6f;
                    float currentmaxwounds = Ability.INNATE.getLevel(nbt);
                    float nextlevelmaxwounds = Ability.INNATE.getLevel(nbt) + 1;
                    if (!Ability.INNATE.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration2);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.maxwounds", (Object[])new Object[0]) + ": 0 " + TextFormatting.GREEN + "+" + nextlevelmaxwounds);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration2 + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + 1.6);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.maxwounds", (Object[])new Object[0]) + ": " + currentmaxwounds + " " + TextFormatting.GREEN + "+" + 1.0);
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration2 + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.maxwounds", (Object[])new Object[0]) + ": " + currentmaxwounds);
                        if (!Ability.INNATE.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 4) {
                    chance = (float)(1.0 / (double)Config.bombasticchance * 100.0);
                    float currentexplosionintensity = Ability.BOMBASTIC.getLevel(nbt);
                    float nextlevelexplosionintensity = Ability.BOMBASTIC.getLevel(nbt) + 1;
                    int c2 = (int)chance;
                    if (!Ability.BOMBASTIC.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c2);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.explosionintensity", (Object[])new Object[0]) + ": 0 " + TextFormatting.GREEN + "+" + nextlevelexplosionintensity);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c2);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.explosionintensity", (Object[])new Object[0]) + ": " + currentexplosionintensity + " " + TextFormatting.GREEN + "+" + (nextlevelexplosionintensity - currentexplosionintensity));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c2);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.explosionintensity", (Object[])new Object[0]) + ": " + currentexplosionintensity);
                        if (!Ability.BOMBASTIC.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 5) {
                    chance = (float)(1.0 / (double)Config.criticalpointchance * 100.0);
                    float currentdamage = Ability.CRITICAL_POINT.getLevel(nbt) * 17;
                    float nextleveldamage = (Ability.CRITICAL_POINT.getLevel(nbt) + 1) * 17;
                    int c3 = (int)chance;
                    if (!Ability.CRITICAL_POINT.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c3);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.healthpercentage", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + nextleveldamage);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c3);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.healthpercentage", (Object[])new Object[0]) + ": %" + currentdamage + " " + TextFormatting.GREEN + "+ %" + (nextleveldamage - currentdamage));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c3);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.healthpercentage", (Object[])new Object[0]) + ": %" + currentdamage);
                        if (!Ability.CRITICAL_POINT.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 6) {
                    if (!Ability.ILLUMINATION.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + 5.0);
                        }
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + 5.0 + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                    }
                    if (!Ability.ILLUMINATION.canUpgradeLevel(nbt) && !buttons[i].field_146124_l) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                    }
                }
                if (i == 7) {
                    float currentrepair = Ability.ETHEREAL.getLevel(nbt) * 2;
                    float nextlevelrepair = (Ability.ETHEREAL.getLevel(nbt) + 1) * 2;
                    if (!Ability.ETHEREAL.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.durability", (Object[])new Object[0]) + ": 0" + TextFormatting.GREEN + " +" + 2.0);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.durability", (Object[])new Object[0]) + ": " + currentrepair + " " + TextFormatting.GREEN + "+" + (nextlevelrepair - currentrepair));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.durability", (Object[])new Object[0]) + ": " + currentrepair);
                        if (!Ability.ETHEREAL.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 8) {
                    float currentpercentage = Ability.BLOODTHIRST.getLevel(nbt) * 12;
                    float nextlevelpercentage = (Ability.BLOODTHIRST.getLevel(nbt) + 1) * 12;
                    if (!Ability.BLOODTHIRST.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.damagepercentage", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + nextlevelpercentage);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.damagepercentage", (Object[])new Object[0]) + ": %" + currentpercentage + " " + TextFormatting.GREEN + "+ %" + (nextlevelpercentage - currentpercentage));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.damagepercentage", (Object[])new Object[0]) + ": %" + currentpercentage);
                        if (!Ability.BLOODTHIRST.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
            } else if (EAUtils.canEnhanceArmor(stack.func_77973_b())) {
                if (i == 0) {
                    float chance = (float)(1.0 / (double)Config.moltenchance) * 100.0f;
                    currentduration = (Ability.MOLTEN.getLevel(nbt) + Ability.MOLTEN.getLevel(nbt) * 5) / 4;
                    nextlevelduration = (Ability.MOLTEN.getLevel(nbt) + 1 + (Ability.MOLTEN.getLevel(nbt) + 1) * 5) / 4;
                    int c = (int)chance;
                    if (!Ability.MOLTEN.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.MOLTEN.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 1) {
                    float chance = (float)(1.0 / (double)Config.frozenchance) * 100.0f;
                    currentduration = (Ability.FROZEN.getLevel(nbt) + Ability.FROZEN.getLevel(nbt) * 5) / 6;
                    nextlevelduration = (Ability.FROZEN.getLevel(nbt) + 1 + (Ability.FROZEN.getLevel(nbt) + 1) * 5) / 6;
                    int c = (int)chance;
                    if (!Ability.FROZEN.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.FROZEN.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 2) {
                    float chance = (float)(1.0 / (double)Config.toxicchance) * 100.0f;
                    currentduration = (Ability.TOXIC.getLevel(nbt) + Ability.TOXIC.getLevel(nbt) * 4) / 4;
                    nextlevelduration = (Ability.TOXIC.getLevel(nbt) + 1 + (Ability.TOXIC.getLevel(nbt) + 1) * 4) / 4;
                    int c = (int)chance;
                    if (!Ability.TOXIC.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.TOXIC.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
                if (i == 3) {
                    if (!Ability.BEASTIAL.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + 7.0);
                        }
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + 7.0 + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                    }
                    if (!Ability.BEASTIAL.canUpgradeLevel(nbt) && !buttons[i].field_146124_l) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                    }
                }
                if (i == 4) {
                    float heal = Ability.REMEDIAL.getLevel(nbt);
                    if (!Ability.REMEDIAL.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            heal = 1.0f;
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.heal_amount", (Object[])new Object[0]) + ": 0 " + TextFormatting.GREEN + "+" + heal);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.heal_amount", (Object[])new Object[0]) + ": " + heal + TextFormatting.GREEN + " +" + 1.0);
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.heal_amount", (Object[])new Object[0]) + ": " + heal);
                    }
                    if (!Ability.REMEDIAL.canUpgradeLevel(nbt) && !buttons[i].field_146124_l) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                    }
                }
                if (i == 5) {
                    float chance = (float)(1.0 / (double)Config.hardenedchance * 100.0);
                    if (!Ability.HARDENED.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + chance);
                        }
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + chance);
                    }
                    if (!Ability.HARDENED.canUpgradeLevel(nbt) && !buttons[i].field_146124_l) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                    }
                }
                if (i == 6) {
                    float chance = (float)(1.0 / (double)Config.adrenalinechance) * 100.0f;
                    currentduration = (Ability.ADRENALINE.getLevel(nbt) + Ability.ADRENALINE.getLevel(nbt) * 5) / 3;
                    nextlevelduration = (Ability.ADRENALINE.getLevel(nbt) + 1 + (Ability.ADRENALINE.getLevel(nbt) + 1) * 5) / 3;
                    int c = (int)chance;
                    if (!Ability.ADRENALINE.hasAbility(nbt)) {
                        if (buttons[i].field_146124_l) {
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %0" + TextFormatting.GREEN + " + %" + c);
                            list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": 0 " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + nextlevelduration);
                        }
                    } else if (buttons[i].field_146124_l) {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]) + TextFormatting.GREEN + " +" + (nextlevelduration - currentduration));
                    } else {
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.chance", (Object[])new Object[0]) + ": %" + c);
                        list.add(I18n.func_135052_a((String)"enhancedarmaments.abilities.info.duration", (Object[])new Object[0]) + ": " + currentduration + " " + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.seconds", (Object[])new Object[0]));
                        if (!Ability.ADRENALINE.canUpgradeLevel(nbt)) {
                            list.add(TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]));
                        }
                    }
                }
            }
            int explevel = abilities.get(i).getExpLevel(nbt);
            if (!abilities.get(i).hasAbility(nbt)) {
                list.add("");
                if (abilities.get(i).hasEnoughExp((EntityPlayer)player, nbt)) {
                    list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.required_exp", (Object[])new Object[0]) + ": " + explevel);
                } else {
                    list.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.required_exp", (Object[])new Object[0]) + ": " + explevel);
                }
            } else if (abilities.get(i).canUpgradeLevel(nbt)) {
                if (Experience.getAbilityTokens(nbt) >= abilities.get(i).getTier()) {
                    list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.required_token", (Object[])new Object[0]) + ": " + abilities.get(i).getTier());
                } else {
                    list.add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"enhancedarmaments.abilities.info.required_token", (Object[])new Object[0]) + ": " + abilities.get(i).getTier());
                }
            }
            this.func_146283_a(list, mouseX + 3, mouseY + 3);
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

