/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.commands;

import com.google.common.collect.Lists;
import com.kenymylankca.enhancedarmaments.commands.UsageException;
import com.kenymylankca.enhancedarmaments.essentials.Experience;
import com.kenymylankca.enhancedarmaments.util.EAUtils;
import com.kenymylankca.enhancedarmaments.util.NBTHelper;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;

public class WPCommandExpLevel
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"addlevel"});

    public String func_71517_b() {
        return "addlevel";
    }

    public String func_71518_a(ICommandSender sender) {
        return "addlevel <level count>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws UsageException {
        if (args.length < 1 || args.length > 1) {
            throw new UsageException("Usage: /addlevel <count>");
        }
        if (args.length < 1 || args.length > 1) {
            return;
        }
        if (!WPCommandExpLevel.isInteger(args[0])) {
            throw new UsageException("Enter a number! Example: /addlevel 4");
        }
        if (sender instanceof EntityPlayer && WPCommandExpLevel.isInteger(args[0])) {
            WPCommandExpLevel.AddLevel((EntityPlayer)sender, args[0]);
        }
    }

    public static void AddLevel(EntityPlayer player, String count) throws UsageException {
        int c = Integer.parseInt(count);
        if (c < 1) {
            throw new UsageException("Level count must be bigger than 0!");
        }
        if (EAUtils.canEnhance(player.func_184614_ca().func_77973_b()) && c > 0) {
            ItemStack item = player.func_184614_ca();
            NBTTagCompound nbt = NBTHelper.loadStackNBT(item);
            for (int i = 0; i < c; ++i) {
                if (!Experience.canLevelUp(nbt)) continue;
                Experience.setExperience(nbt, Experience.getExperience(nbt) + Experience.getNeededExpForNextLevel(nbt));
                Experience.setLevel(nbt, Experience.getLevel(nbt) + 1);
                Experience.setAbilityTokens(nbt, Experience.getAbilityTokens(nbt) + 1);
            }
            NBTHelper.saveStackNBT(item, nbt);
            player.func_184611_a(EnumHand.MAIN_HAND, item);
        }
        if (!EAUtils.canEnhance(player.func_184614_ca().func_77973_b())) {
            throw new UsageException("Hold a weapon or an armor in your mainhand!");
        }
    }

    public static boolean isInteger(String s) {
        return WPCommandExpLevel.isInteger(s, 10);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }
}

