/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.commands;

import com.google.common.collect.Lists;
import com.kenymylankca.enhancedarmaments.commands.UsageException;
import com.kenymylankca.enhancedarmaments.util.EAUtils;
import com.kenymylankca.enhancedarmaments.util.NBTHelper;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;

public class WPCommandRarity
extends CommandBase {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"changerarity"});

    public String func_71517_b() {
        return "changerarity";
    }

    public String func_71518_a(ICommandSender sender) {
        return "rarity <rarityname>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws UsageException {
        if (args.length < 1 || args.length > 1) {
            throw new UsageException("Usage: /changerarity <id>");
        }
        if (args.length < 1 || args.length > 1) {
            return;
        }
        if (!WPCommandRarity.isInteger(args[0])) {
            throw new UsageException("Enter an id! \n1:Basic\n2:Uncommon\n3:Rare\n4:Ultra Rare\n5:Legendary\n6:Ancient");
        }
        if (sender instanceof EntityPlayer && WPCommandRarity.isInteger(args[0])) {
            WPCommandRarity.ChangeRarity((EntityPlayer)sender, args[0]);
        }
    }

    public static void ChangeRarity(EntityPlayer player, String rarityid) throws UsageException {
        int rarityNumber = Integer.parseInt(rarityid);
        if (rarityNumber < 1 || rarityNumber > 6) {
            throw new UsageException("Rarity ID must be 1, 2, 3, 4, 5 or 6!");
        }
        if (EAUtils.canEnhance(player.func_184614_ca().func_77973_b()) && rarityNumber < 7 && rarityNumber > 0) {
            ItemStack item = player.func_184614_ca();
            NBTTagCompound nbt = NBTHelper.loadStackNBT(item);
            nbt.func_74768_a("RARITY", rarityNumber);
            NBTHelper.saveStackNBT(item, nbt);
            player.func_184611_a(EnumHand.MAIN_HAND, item);
        }
        if (!EAUtils.canEnhance(player.func_184614_ca().func_77973_b())) {
            throw new UsageException("Hold a weapon or an armor in your mainhand!");
        }
    }

    public static boolean isInteger(String s) {
        return WPCommandRarity.isInteger(s, 10);
    }

    public static boolean isInteger(String s, int radix) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), radix) < 0)) continue;
            return false;
        }
        return true;
    }
}

