/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.config;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config {
    private static Configuration main;
    private static Configuration abilities;
    private static Configuration abilitychances;
    private static Configuration rarities;
    public static int maxLevel;
    public static int level1Experience;
    public static double experienceMultiplier;
    public static boolean showDurability;
    public static String[] itemBlacklist;
    public static String[] itemWhitelist;
    public static String[] extraItems;
    public static String stringPosition;
    public static boolean onlyModdedItems;
    public static boolean fire;
    public static boolean frost;
    public static boolean poison;
    public static boolean innate;
    public static boolean bombastic;
    public static boolean criticalpoint;
    public static boolean illumination;
    public static boolean ethereal;
    public static boolean bloodthirst;
    public static boolean molten;
    public static boolean frozen;
    public static boolean toxic;
    public static boolean adrenaline;
    public static boolean beastial;
    public static boolean remedial;
    public static boolean hardened;
    public static int firechance;
    public static int frostchance;
    public static int poisonchance;
    public static int bombasticchance;
    public static int criticalpointchance;
    public static int moltenchance;
    public static int frozenchance;
    public static int toxicchance;
    public static int adrenalinechance;
    public static int hardenedchance;
    public static double basicChance;
    public static double uncommonChance;
    public static double rareChance;
    public static double ultraRareChance;
    public static double legendaryChance;
    public static double ancientChance;
    public static double basicEffect;
    public static double uncommonEffect;
    public static double rareEffect;
    public static double ultraRareEffect;
    public static double legendaryEffect;
    public static double ancientEffect;

    public static void init(File dir) {
        main = new Configuration(new File(dir.getPath(), "main.cfg"));
        abilities = new Configuration(new File(dir.getPath(), "abilities.cfg"));
        abilitychances = new Configuration(new File(dir.getPath(), "abilitychances.cfg"));
        rarities = new Configuration(new File(dir.getPath(), "rarities.cfg"));
        Config.sync();
    }

    private static void sync() {
        Config.syncMain();
        Config.syncAbilities();
        Config.syncAbilityChances();
        Config.syncRarities();
    }

    private static void syncMain() {
        String category = "main";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = main.get(category, "maxLevel", maxLevel);
        prop.setComment("Sets the maximum level cap for weapons and armor. Default: 10");
        maxLevel = prop.getInt();
        propOrder.add(prop.getName());
        prop = main.get(category, "level1Experience", level1Experience);
        prop.setComment("The experience amount needed for the first level(1). Default: 120");
        level1Experience = prop.getInt();
        propOrder.add(prop.getName());
        prop = main.get(category, "experienceMultiplier", experienceMultiplier);
        prop.setComment("The experience multiplier for each level based on the first level experience. Default: 1.9");
        experienceMultiplier = prop.getDouble();
        propOrder.add(prop.getName());
        prop = main.get(category, "showDurabilityInTooltip", showDurability);
        prop.setComment("Determines whether or not durability will be displayed in tooltips. Default: true");
        showDurability = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = main.get(category, "itemBlacklist", itemBlacklist);
        prop.setComment("Items in this blacklist will not gain the leveling systems. Useful for very powerful items or potential conflicts. Style should be 'modid:item'");
        itemBlacklist = prop.getStringList();
        propOrder.add(prop.getName());
        prop = main.get(category, "itemWhitelist", itemWhitelist);
        prop.setComment("This is item whitelist, basically. If you don't want a whitelist, just leave this empty. If you want a whitelist, fill it with items you want. Style should be 'modid:item'");
        itemWhitelist = prop.getStringList();
        propOrder.add(prop.getName());
        prop = main.get(category, "extraItems", extraItems);
        prop.setComment("This is an extra item list to add custom support for such modded items. Be careful on this, it may crash if the item can't be enhanced. Style should be 'modid:item'. \nExample: tconstruct:broadsword");
        extraItems = prop.getStringList();
        propOrder.add(prop.getName());
        prop = main.get(category, "onlyModdedItems", onlyModdedItems);
        prop.setComment("Determines if the vanilla items won't be affected by this mod. Default: false");
        onlyModdedItems = prop.getBoolean();
        propOrder.add(prop.getName());
        main.setCategoryPropertyOrder(category, (List)propOrder);
        main.save();
    }

    private static void syncAbilities() {
        String category = "abilities";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = abilities.get(category, "fireAbility", fire);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        fire = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "frostAbility", frost);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        frost = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "poisonAbility", poison);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        poison = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "innateAbility", innate);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        innate = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "bombasticAbility", bombastic);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        bombastic = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "criticalpointAbility", criticalpoint);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        criticalpoint = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "illuminationAbility", illumination);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        illumination = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "etherealAbility", ethereal);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        ethereal = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "bloodthirstAbility", bloodthirst);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        bloodthirst = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "moltenAbility", molten);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        molten = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "frozenAbility", frozen);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        frozen = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "toxicAbility", toxic);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        toxic = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "adrenalineAbility", adrenaline);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        adrenaline = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "beastialAbility", beastial);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        beastial = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "remedialAbility", remedial);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        remedial = prop.getBoolean();
        propOrder.add(prop.getName());
        prop = abilities.get(category, "hardenedAbility", hardened);
        prop.setComment("Determines whether or not the specific ability will be present in-game. Default: true");
        hardened = prop.getBoolean();
        propOrder.add(prop.getName());
        abilities.setCategoryPropertyOrder(category, (List)propOrder);
        abilities.save();
    }

    private static void syncAbilityChances() {
        String category = "abilitychances";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = abilitychances.get(category, "firechance", firechance);
        prop.setComment("Determines how rare the Fire ability will occur. (Higher values=lower occurance) Default: 4");
        firechance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "frostchance", frostchance);
        prop.setComment("Determines how rare the Frost ability will occur. (Higher values=lower occurance) Default: 4");
        frostchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "poisonchance", poisonchance);
        prop.setComment("Determines how rare the Poison ability will occur. (Higher values=lower occurance) Default: 4");
        poisonchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "bombasticchance", bombasticchance);
        prop.setComment("Determines how rare the Bombastic ability will occur. (Higher values=lower occurance) Default: 7");
        bombasticchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "criticalpointchance", criticalpointchance);
        prop.setComment("Determines how rare the Critical Point ability will occur. (Higher values=lower occurance) Default: 14");
        criticalpointchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "moltenchance", moltenchance);
        prop.setComment("Determines how rare the Molten ability will occur. (Higher values=lower occurance) Default: 4");
        moltenchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "frozenchance", frozenchance);
        prop.setComment("Determines how rare the Frozen ability will occur. (Higher values=lower occurance) Default: 4");
        frozenchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "toxicchance", toxicchance);
        prop.setComment("Determines how rare the Toxic ability will occur. (Higher values=lower occurance) Default: 4");
        toxicchance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "adrenalinechance", adrenalinechance);
        prop.setComment("Determines how rare the Adrenaline ability will occur. (Higher values=lower occurance) Default: 7");
        adrenalinechance = prop.getInt();
        propOrder.add(prop.getName());
        prop = abilitychances.get(category, "hardenedchance", hardenedchance);
        prop.setComment("Determines how rare the Hardened ability will occur. (Higher values=lower occurance) Default: 10");
        hardenedchance = prop.getInt();
        propOrder.add(prop.getName());
        abilitychances.setCategoryPropertyOrder(category, (List)propOrder);
        abilitychances.save();
    }

    private static void syncRarities() {
        String category = "rarities";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = rarities.get(category, "basicChance", basicChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.5");
        basicChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "uncommonChance", uncommonChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.18");
        uncommonChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "rareChance", rareChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.10");
        rareChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ultraRareChance", ultraRareChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.05");
        ultraRareChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "legendaryChance", legendaryChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.02");
        legendaryChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ancientChance", ancientChance);
        prop.setComment("Sets the chance the given rarity will be applied. Default: 0.01");
        ancientChance = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "basicEffect", basicEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0");
        basicEffect = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "uncommonEffect", uncommonEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0.155");
        uncommonEffect = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "rareEffect", rareEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0.305");
        rareEffect = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ultraRareEffect", ultraRareEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0.38");
        ultraRareEffect = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "legendaryEffect", legendaryEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0.71");
        legendaryEffect = prop.getDouble();
        propOrder.add(prop.getName());
        prop = rarities.get(category, "ancientEffect", ancientEffect);
        prop.setComment("Sets the effectiveness for the given rarity. Default: 0.91");
        ancientEffect = prop.getDouble();
        propOrder.add(prop.getName());
        rarities.setCategoryPropertyOrder(category, (List)propOrder);
        rarities.save();
    }

    static {
        maxLevel = 10;
        level1Experience = 120;
        experienceMultiplier = 1.9;
        showDurability = true;
        itemBlacklist = new String[0];
        itemWhitelist = new String[0];
        extraItems = new String[0];
        stringPosition = "default";
        onlyModdedItems = false;
        fire = true;
        frost = true;
        poison = true;
        innate = true;
        bombastic = true;
        criticalpoint = true;
        illumination = true;
        ethereal = true;
        bloodthirst = true;
        molten = true;
        frozen = true;
        toxic = true;
        adrenaline = true;
        beastial = true;
        remedial = true;
        hardened = true;
        firechance = 4;
        frostchance = 4;
        poisonchance = 4;
        bombasticchance = 7;
        criticalpointchance = 14;
        moltenchance = 4;
        frozenchance = 4;
        toxicchance = 4;
        adrenalinechance = 7;
        hardenedchance = 10;
        basicChance = 0.5;
        uncommonChance = 0.18;
        rareChance = 0.1;
        ultraRareChance = 0.05;
        legendaryChance = 0.02;
        ancientChance = 0.01;
        basicEffect = 0.0;
        uncommonEffect = 0.155;
        rareEffect = 0.305;
        ultraRareEffect = 0.38;
        legendaryEffect = 0.71;
        ancientEffect = 0.91;
    }
}

