/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.essentials;

import com.kenymylankca.enhancedarmaments.config.Config;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public enum Ability {
    FIRE("weapon", "active", Config.fire, TextFormatting.RED, 0xFF5555, 1, 3),
    FROST("weapon", "active", Config.frost, TextFormatting.AQUA, 0x55FFFF, 1, 3),
    POISON("weapon", "active", Config.poison, TextFormatting.DARK_GREEN, 43520, 1, 3),
    INNATE("weapon", "active", Config.innate, TextFormatting.DARK_RED, 0xAA0000, 2, 3),
    BOMBASTIC("weapon", "active", Config.bombastic, TextFormatting.GRAY, 0xAAAAAA, 3, 3),
    CRITICAL_POINT("weapon", "active", Config.criticalpoint, TextFormatting.DARK_GRAY, 0x555555, 3, 3),
    ILLUMINATION("weapon", "passive", Config.illumination, TextFormatting.YELLOW, 0xFFFF55, 2, 1),
    ETHEREAL("weapon", "passive", Config.ethereal, TextFormatting.GREEN, 0x55FF55, 2, 2),
    BLOODTHIRST("weapon", "passive", Config.bloodthirst, TextFormatting.DARK_PURPLE, 0xAA00AA, 3, 2),
    MOLTEN("armor", "active", Config.molten, TextFormatting.RED, 0xFF5555, 2, 2),
    FROZEN("armor", "active", Config.frozen, TextFormatting.AQUA, 0x55FFFF, 2, 2),
    TOXIC("armor", "active", Config.toxic, TextFormatting.DARK_GREEN, 43520, 2, 2),
    BEASTIAL("armor", "passive", Config.beastial, TextFormatting.DARK_RED, 0xAA0000, 2, 1),
    REMEDIAL("armor", "passive", Config.remedial, TextFormatting.LIGHT_PURPLE, 0xFF55FF, 2, 2),
    HARDENED("armor", "passive", Config.hardened, TextFormatting.GRAY, 0xAAAAAA, 3, 1),
    ADRENALINE("armor", "passive", Config.adrenaline, TextFormatting.GREEN, 0x55FF55, 3, 1);

    public static int WEAPON_ABILITIES_COUNT;
    public static int ARMOR_ABILITIES_COUNT;
    public static final ArrayList<Ability> WEAPON_ABILITIES;
    public static final ArrayList<Ability> ARMOR_ABILITIES;
    public static final ArrayList<Ability> ALL_ABILITIES;
    private String category;
    private String type;
    private boolean enabled;
    private String color;
    private int hex;
    private int tier;
    private int maxlevel;

    private Ability(String category, String type, boolean enabled, Object color, int hex, int tier, int maxlevel) {
        this.category = category;
        this.type = type;
        this.enabled = enabled;
        this.color = color.toString();
        this.hex = hex;
        this.tier = tier;
        this.maxlevel = maxlevel;
    }

    public boolean hasAbility(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74762_e(this.toString()) > 0;
    }

    public void addAbility(NBTTagCompound nbt) {
        nbt.func_74768_a(this.toString(), 1);
        if (nbt.func_74764_b("ABILITIES")) {
            nbt.func_74768_a("ABILITIES", nbt.func_74762_e("ABILITIES") + 1);
        } else {
            nbt.func_74768_a("ABILITIES", 1);
        }
    }

    public void removeAbility(NBTTagCompound nbt) {
        nbt.func_82580_o(this.toString());
        if (nbt.func_74764_b("ABILITIES") && nbt.func_74762_e("ABILITIES") > 0) {
            nbt.func_74768_a("ABILITIES", nbt.func_74762_e("ABILITIES") - 1);
        }
    }

    public boolean hasEnoughExp(EntityPlayer player, NBTTagCompound nbt) {
        return this.getExpLevel(nbt) <= player.field_71068_ca || player.func_184812_l_();
    }

    public int getExpLevel(NBTTagCompound nbt) {
        int requiredExpLevel = 0;
        requiredExpLevel = nbt.func_74764_b("ABILITIES") ? (this.getTier() + this.getMaxLevel()) * (nbt.func_74762_e("ABILITIES") + 1) - 1 : this.getTier() + this.getMaxLevel();
        return requiredExpLevel;
    }

    public void setLevel(NBTTagCompound nbt, int level) {
        nbt.func_74768_a(this.toString(), level);
    }

    public int getLevel(NBTTagCompound nbt) {
        if (nbt != null) {
            return nbt.func_74762_e(this.toString());
        }
        return 0;
    }

    public boolean canUpgradeLevel(NBTTagCompound nbt) {
        return this.getLevel(nbt) < this.maxlevel;
    }

    public int getTier() {
        return this.tier;
    }

    public int getMaxLevel() {
        return this.maxlevel;
    }

    public String getColor() {
        return this.color;
    }

    public int getHex() {
        return this.hex;
    }

    public String getName() {
        return this.toString();
    }

    public String getName(NBTTagCompound nbt) {
        if (this.getLevel(nbt) == 2) {
            return new TextComponentTranslation("enhancedarmaments.ability." + this.toString(), new Object[0]).func_150254_d() + " II";
        }
        if (this.getLevel(nbt) == 3) {
            return new TextComponentTranslation("enhancedarmaments.ability." + this.toString(), new Object[0]).func_150254_d() + " III";
        }
        return new TextComponentTranslation("enhancedarmaments.ability." + this.toString(), new Object[0]).func_150254_d();
    }

    public String getType() {
        return this.type;
    }

    public String getTypeName() {
        return new TextComponentTranslation("enhancedarmaments.ability.type." + this.type.toString(), new Object[0]).func_150254_d();
    }

    public String getCategory() {
        return this.category;
    }

    static {
        WEAPON_ABILITIES_COUNT = 0;
        ARMOR_ABILITIES_COUNT = 0;
        WEAPON_ABILITIES = new ArrayList();
        ARMOR_ABILITIES = new ArrayList();
        ALL_ABILITIES = new ArrayList();
        for (int i = 0; i < Ability.values().length; ++i) {
            ALL_ABILITIES.add(Ability.values()[i]);
            if (Ability.values()[i].getCategory().equals("weapon") && Ability.values()[i].enabled) {
                WEAPON_ABILITIES.add(Ability.values()[i]);
                ++WEAPON_ABILITIES_COUNT;
                continue;
            }
            if (!Ability.values()[i].getCategory().equals("armor") || !Ability.values()[i].enabled) continue;
            ARMOR_ABILITIES.add(Ability.values()[i]);
            ++ARMOR_ABILITIES_COUNT;
        }
    }
}

