/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.essentials;

import com.kenymylankca.enhancedarmaments.config.Config;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class Experience {
    public static int getNextLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt, int currentLevel, int experience) {
        int newLevel = currentLevel;
        while (currentLevel < Config.maxLevel && experience >= Experience.getMaxLevelExp(currentLevel)) {
            newLevel = currentLevel + 1;
            ++currentLevel;
            Experience.setAbilityTokens(nbt, Experience.getAbilityTokens(nbt) + 1);
            player.func_145747_a((ITextComponent)new TextComponentString(stack.func_82833_r() + TextFormatting.GRAY + " " + new TextComponentTranslation("enhancedarmaments.misc.level.leveledup", new Object[0]).func_150254_d() + " " + TextFormatting.GOLD + "" + newLevel + TextFormatting.GRAY + "!"));
        }
        return newLevel;
    }

    public static int getLevel(NBTTagCompound nbt) {
        return nbt != null ? Math.max(nbt.func_74762_e("LEVEL"), 1) : 1;
    }

    public static boolean canLevelUp(NBTTagCompound nbt) {
        return Experience.getLevel(nbt) < Config.maxLevel;
    }

    public static void setLevel(NBTTagCompound nbt, int level) {
        if (nbt != null) {
            if (level > 1) {
                nbt.func_74768_a("LEVEL", level);
            } else {
                nbt.func_82580_o("LEVEL");
            }
        }
    }

    public static int getNeededExpForNextLevel(NBTTagCompound nbt) {
        int neededexp = Experience.getMaxLevelExp(Experience.getLevel(nbt)) - Experience.getExperience(nbt);
        return nbt != null ? neededexp : 0;
    }

    public static int getExperience(NBTTagCompound nbt) {
        return nbt.func_74764_b("EXPERIENCE") ? nbt.func_74762_e("EXPERIENCE") : 0;
    }

    public static void setExperience(NBTTagCompound nbt, int experience) {
        if (nbt != null) {
            if (experience > 0) {
                nbt.func_74768_a("EXPERIENCE", experience);
            } else {
                nbt.func_82580_o("EXPERIENCE");
            }
        }
    }

    public static int getMaxLevelExp(int level) {
        int maxLevelExp = Config.level1Experience;
        for (int i = 1; i < level; ++i) {
            maxLevelExp = (int)((double)maxLevelExp * Config.experienceMultiplier);
        }
        return maxLevelExp;
    }

    public static void setAbilityTokens(NBTTagCompound nbt, int tokens) {
        if (nbt != null) {
            if (tokens > 0) {
                nbt.func_74768_a("TOKENS", tokens);
            } else {
                nbt.func_82580_o("TOKENS");
            }
        }
    }

    public static int getAbilityTokens(NBTTagCompound nbt) {
        return nbt != null ? nbt.func_74762_e("TOKENS") : 0;
    }

    public static void enable(NBTTagCompound nbt, boolean value) {
        if (nbt != null) {
            if (value) {
                nbt.func_74757_a("EA_ENABLED", value);
            } else {
                nbt.func_82580_o("EA_ENABLED");
            }
        }
    }

    public static boolean isEnabled(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b("EA_ENABLED");
    }
}

