/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.event;

import com.google.common.collect.Multimap;
import com.kenymylankca.enhancedarmaments.config.Config;
import com.kenymylankca.enhancedarmaments.essentials.Ability;
import com.kenymylankca.enhancedarmaments.essentials.Experience;
import com.kenymylankca.enhancedarmaments.essentials.Rarity;
import com.kenymylankca.enhancedarmaments.util.EAUtils;
import com.kenymylankca.enhancedarmaments.util.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EventItemTooltip {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addInformation(ItemTooltipEvent event) {
        NBTTagCompound nbt;
        ArrayList tooltip = (ArrayList)event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item != null && EAUtils.canEnhance(item) && (nbt = NBTHelper.loadStackNBT(stack)) != null && Experience.isEnabled(nbt)) {
            Rarity rarity = Rarity.getRarity(nbt);
            int level = Experience.getLevel(nbt);
            int experience = Experience.getExperience(nbt);
            int maxExperience = Experience.getMaxLevelExp(level);
            this.changeTooltips(tooltip, stack, rarity);
            if (level >= Config.maxLevel) {
                tooltip.add(I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + TextFormatting.WHITE + level);
            }
            if (level >= Config.maxLevel) {
                tooltip.add(I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + experience + " / " + maxExperience);
            }
            if (Config.showDurability) {
                tooltip.add(I18n.func_135052_a((String)"enhancedarmaments.misc.durability", (Object[])new Object[0]) + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k());
            }
            tooltip.add("");
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                tooltip.add(rarity.getColor() + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities", (Object[])new Object[0]));
                tooltip.add("");
                if (EAUtils.canEnhanceWeapon(item)) {
                    for (Ability ability : Ability.WEAPON_ABILITIES) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add("-" + ability.getColor() + ability.getName(nbt));
                    }
                } else if (EAUtils.canEnhanceArmor(item)) {
                    for (Ability ability : Ability.ARMOR_ABILITIES) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add("-" + ability.getColor() + ability.getName(nbt));
                    }
                }
            } else {
                tooltip.add(rarity.getColor() + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities.shift", (Object[])new Object[0]));
            }
        }
    }

    private void changeTooltips(ArrayList<String> tooltip, ItemStack stack, Rarity rarity) {
        tooltip.set(0, stack.func_82833_r() + rarity.getColor() + " (" + TextFormatting.ITALIC + I18n.func_135052_a((String)("enhancedarmaments.rarity." + rarity.getName()), (Object[])new Object[0]) + ")");
        if (tooltip.indexOf("When in main hand:") != -1 && !(stack.func_77973_b() instanceof ItemBow)) {
            Multimap map = stack.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
            Collection damageCollection = map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            double originalDamage = damageModifier.func_111164_d() + 1.0;
            if (stack.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack) > 0) {
                originalDamage += (double)((EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack) + 1) / 2);
            }
            double damage = originalDamage * rarity.getEffect() + originalDamage;
            String attackDamageString = String.format("%.1f", damage);
            if (rarity.getEffect() != 0.0) {
                for (int i = 0; i < tooltip.size(); ++i) {
                    if (!tooltip.get(i).contains("Attack Damage")) continue;
                    tooltip.set(i, rarity.getColor() + " " + attackDamageString + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.tooltip.attackdamage", (Object[])new Object[0]));
                }
            }
        }
        if (tooltip.indexOf("When on head:") != -1 || tooltip.indexOf("When on body:") != -1 || tooltip.indexOf("When on legs:") != -1 || tooltip.indexOf("When on feet:") != -1) {
            String p = String.format("%.1f", 100.0 - 100.0 / (1.0 + rarity.getEffect() / 5.0));
            float percentage = Float.valueOf(p).floatValue();
            int line = 2;
            if (tooltip.indexOf("When on head:") != -1) {
                line = tooltip.indexOf("When on head:");
            }
            if (tooltip.indexOf("When on body:") != -1) {
                line = tooltip.indexOf("When on body:");
            }
            if (tooltip.indexOf("When on legs:") != -1) {
                line = tooltip.indexOf("When on legs:");
            }
            if (tooltip.indexOf("When on feet:") != -1) {
                line = tooltip.indexOf("When on feet:");
            }
            if (percentage != 0.0f) {
                tooltip.add(line + 1, " " + TextFormatting.BLUE + "+" + rarity.getColor() + percentage + TextFormatting.BLUE + "% " + I18n.func_135052_a((String)"enhancedarmaments.misc.rarity.armorreduction", (Object[])new Object[0]));
            }
        }
        if (EAUtils.canEnhanceRanged(stack.func_77973_b()) && rarity.getEffect() != 0.0) {
            String b = String.format("%.1f", rarity.getEffect() / 3.0 * 100.0);
            tooltip.add(1, I18n.func_135052_a((String)"enhancedarmaments.misc.rarity.arrowpercentage", (Object[])new Object[0]) + " " + rarity.getColor() + "+" + b + "%");
        }
    }
}

