/*
 * Decompiled with CFR 0.152.
 */
package com.kenymylankca.enhancedarmaments.event;

import com.kenymylankca.enhancedarmaments.config.Config;
import com.kenymylankca.enhancedarmaments.essentials.Ability;
import com.kenymylankca.enhancedarmaments.essentials.Experience;
import com.kenymylankca.enhancedarmaments.event.EventLivingHurt;
import com.kenymylankca.enhancedarmaments.util.EAUtils;
import com.kenymylankca.enhancedarmaments.util.NBTHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventLivingDeath {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack stack = player.func_184586_b(EventLivingHurt.bowfriendlyhand);
            if (stack != null && EAUtils.canEnhanceMelee(stack.func_77973_b())) {
                NBTTagCompound nbt2 = NBTHelper.loadStackNBT(stack);
                if (nbt2 != null && nbt2.func_74764_b("EA_ENABLED")) {
                    if (Ability.ETHEREAL.hasAbility(nbt2)) {
                        player.field_71071_by.func_70448_g().func_77964_b(player.field_71071_by.func_70448_g().func_77952_i() - Ability.ETHEREAL.getLevel(nbt2) * 2);
                    }
                    this.addBonusExperience(event, nbt2);
                    this.updateLevel(player, stack, nbt2);
                    NBTHelper.saveStackNBT(stack, nbt2);
                }
            } else if (stack != null && EAUtils.canEnhanceRanged(stack.func_77973_b()) && stack != null && (nbt = NBTHelper.loadStackNBT(stack)) != null && nbt.func_74764_b("EA_ENABLED")) {
                if (Ability.ETHEREAL.hasAbility(nbt)) {
                    player.field_71071_by.func_70448_g().func_77964_b(player.field_71071_by.func_70448_g().func_77952_i() - (Ability.ETHEREAL.getLevel(nbt) * 2 + 1));
                }
                this.addBonusExperience(event, nbt);
                this.updateLevel(player, stack, nbt);
            }
        } else if (event.getSource().func_76346_g() instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.getSource().func_76346_g();
            if (arrow.field_70250_c instanceof EntityPlayer) {
                NBTTagCompound nbt;
                EntityPlayer player = (EntityPlayer)arrow.field_70250_c;
                ItemStack stack = player.field_71071_by.func_70448_g();
                if (stack != null && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                    this.addBonusExperience(event, nbt);
                    this.updateLevel(player, stack, nbt);
                }
            }
        }
    }

    private void addBonusExperience(LivingDeathEvent event, NBTTagCompound nbt) {
        if (Experience.getLevel(nbt) < Config.maxLevel && event.getEntityLiving() instanceof EntityLivingBase) {
            EntityLivingBase target = event.getEntityLiving();
            int bonusExperience = 0;
            if (target.func_110138_aP() < 10.0f) {
                bonusExperience = 3;
            } else if (target.func_110138_aP() > 9.0f && target.func_110138_aP() < 20.0f) {
                bonusExperience = 6;
            } else if (target.func_110138_aP() > 19.0f && target.func_110138_aP() < 50.0f) {
                bonusExperience = 15;
            } else if (target.func_110138_aP() > 49.0f && target.func_110138_aP() < 100.0f) {
                bonusExperience = 50;
            } else if (target.func_110138_aP() > 99.0f) {
                bonusExperience = 70;
            }
            Experience.setExperience(nbt, Experience.getExperience(nbt) + bonusExperience);
        }
    }

    private void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
    }
}

