/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.commands;

import com.jannesoon.enhancedarmaments.essentials.Experience;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandAddLevel {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"addlevel").requires(cmd -> cmd.func_197034_c(3))).then((ArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer()))).executes(cmd -> CommandAddLevel.addLevel((CommandSource)cmd.getSource(), (EntityPlayer)((CommandSource)cmd.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"level"))));
    }

    private static int addLevel(CommandSource cmd, EntityPlayer player, int count) {
        if (count < 1) {
            cmd.func_197030_a((ITextComponent)new TextComponentTranslation("Level count must be bigger than 0!", new Object[0]), true);
        } else if (!EAUtils.canEnhance(player.func_184614_ca().func_77973_b())) {
            cmd.func_197030_a((ITextComponent)new TextComponentTranslation("Hold a weapon or an armor in your mainhand!", new Object[0]), true);
        } else {
            ItemStack item = player.func_184614_ca();
            NBTTagCompound nbt = NBTHelper.loadStackNBT(item);
            for (int i = 0; i < count; ++i) {
                if (!Experience.canLevelUp(nbt)) continue;
                Experience.setExperience(nbt, Experience.getExperience(nbt) + Experience.getNeededExpForNextLevel(nbt));
                Experience.setLevel(nbt, Experience.getLevel(nbt) + 1);
                Experience.setAbilityTokens(nbt, Experience.getAbilityTokens(nbt) + 1);
            }
            NBTHelper.saveStackNBT(item, nbt);
            player.func_184611_a(EnumHand.MAIN_HAND, item);
        }
        return count;
    }
}

