/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.commands;

import com.google.common.collect.Lists;
import com.jannesoon.enhancedarmaments.essentials.Rarity;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandRarity {
    private final List<String> aliases = Lists.newArrayList((Object[])new String[]{"changerarity"});

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"changerarity").requires(cmd -> cmd.func_197034_c(3))).then((ArgumentBuilder)Commands.func_197056_a((String)"rarityid", (ArgumentType)IntegerArgumentType.integer()))).executes(cmd -> CommandRarity.changeRarity((CommandSource)cmd.getSource(), (EntityPlayer)((CommandSource)cmd.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)cmd, (String)"rarityid"))));
    }

    public static int changeRarity(CommandSource src, EntityPlayer player, int rarityid) {
        if (rarityid < 1 || rarityid > 6) {
            src.func_197030_a((ITextComponent)new TextComponentTranslation("Rarity ID must be 1, 2, 3, 4, 5 or 6!", new Object[0]), true);
        } else if (!EAUtils.canEnhance(player.func_184614_ca().func_77973_b())) {
            src.func_197030_a((ITextComponent)new TextComponentTranslation("Hold a weapon or an armor in your mainhand!", new Object[0]), true);
        } else {
            ItemStack item = player.func_184614_ca();
            NBTTagCompound nbt = NBTHelper.loadStackNBT(item);
            Rarity.setRarity(nbt, String.valueOf(rarityid));
            NBTHelper.saveStackNBT(item, nbt);
            player.func_184611_a(EnumHand.MAIN_HAND, item);
        }
        return rarityid;
    }
}

