/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.config;

import com.jannesoon.enhancedarmaments.EnhancedArmaments;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final CFile CONFIG;
    public static final ForgeConfigSpec SPEC;
    public static int maxLevel;
    public static int level1Experience;
    public static double experienceMultiplier;
    public static boolean showDurabilityInTooltip;
    public static List<Item> itemBlacklist;
    public static List<Item> itemWhitelist;
    public static List<Item> extraItems;
    public static boolean onlyModdedItems;
    public static boolean fireAbility;
    public static boolean frostAbility;
    public static boolean poisonAbility;
    public static boolean innateAbility;
    public static boolean bombasticAbility;
    public static boolean criticalpointAbility;
    public static boolean illuminationAbility;
    public static boolean etherealAbility;
    public static boolean bloodthirstAbility;
    public static boolean moltenAbility;
    public static boolean frozenAbility;
    public static boolean toxicAbility;
    public static boolean adrenalineAbility;
    public static boolean beastialAbility;
    public static boolean remedialAbility;
    public static boolean hardenedAbility;
    public static double firechance;
    public static double frostchance;
    public static double poisonchance;
    public static double innatechance;
    public static double bombasticchance;
    public static double criticalpointchance;
    public static double moltenchance;
    public static double frozenchance;
    public static double toxicchance;
    public static double adrenalinechance;
    public static double hardenedchance;
    public static double basicChance;
    public static double uncommonChance;
    public static double rareChance;
    public static double ultraRareChance;
    public static double legendaryChance;
    public static double archaicChance;
    public static double basicDamage;
    public static double uncommonDamage;
    public static double rareDamage;
    public static double ultraRareDamage;
    public static double legendaryDamage;
    public static double archaicDamage;

    public static void load() {
        maxLevel = (Integer)Config.CONFIG.maxLevel.get();
        level1Experience = (Integer)Config.CONFIG.level1Experience.get();
        experienceMultiplier = (Double)Config.CONFIG.experienceMultiplier.get();
        showDurabilityInTooltip = (Boolean)Config.CONFIG.showDurabilityInTooltip.get();
        onlyModdedItems = (Boolean)Config.CONFIG.onlyModdedItems.get();
        itemBlacklist = Config.parseItemList((List)Config.CONFIG.itemBlacklist.get());
        itemWhitelist = Config.parseItemList((List)Config.CONFIG.itemWhitelist.get());
        extraItems = Config.parseItemList((List)Config.CONFIG.extraItems.get());
        fireAbility = (Boolean)Config.CONFIG.fireAbility.get();
        frostAbility = (Boolean)Config.CONFIG.frostAbility.get();
        poisonAbility = (Boolean)Config.CONFIG.poisonAbility.get();
        innateAbility = (Boolean)Config.CONFIG.innateAbility.get();
        bombasticAbility = (Boolean)Config.CONFIG.bombasticAbility.get();
        criticalpointAbility = (Boolean)Config.CONFIG.criticalpointAbility.get();
        illuminationAbility = (Boolean)Config.CONFIG.illuminationAbility.get();
        etherealAbility = (Boolean)Config.CONFIG.etherealAbility.get();
        bloodthirstAbility = (Boolean)Config.CONFIG.bloodthirstAbility.get();
        moltenAbility = (Boolean)Config.CONFIG.moltenAbility.get();
        frozenAbility = (Boolean)Config.CONFIG.frozenAbility.get();
        toxicAbility = (Boolean)Config.CONFIG.toxicAbility.get();
        adrenalineAbility = (Boolean)Config.CONFIG.adrenalineAbility.get();
        beastialAbility = (Boolean)Config.CONFIG.beastialAbility.get();
        remedialAbility = (Boolean)Config.CONFIG.remedialAbility.get();
        hardenedAbility = (Boolean)Config.CONFIG.hardenedAbility.get();
        fireAbility = (Boolean)Config.CONFIG.fireAbility.get();
        firechance = (Double)Config.CONFIG.firechance.get();
        frostchance = (Double)Config.CONFIG.frostchance.get();
        poisonchance = (Double)Config.CONFIG.poisonchance.get();
        innatechance = (Double)Config.CONFIG.innatechance.get();
        bombasticchance = (Double)Config.CONFIG.bombasticchance.get();
        criticalpointchance = (Double)Config.CONFIG.criticalpointchance.get();
        moltenchance = (Double)Config.CONFIG.moltenchance.get();
        frozenchance = (Double)Config.CONFIG.frozenchance.get();
        toxicchance = (Double)Config.CONFIG.toxicchance.get();
        adrenalinechance = (Double)Config.CONFIG.adrenalinechance.get();
        hardenedchance = (Double)Config.CONFIG.hardenedchance.get();
        basicChance = (Double)Config.CONFIG.basicChance.get();
        uncommonChance = (Double)Config.CONFIG.uncommonChance.get();
        rareChance = (Double)Config.CONFIG.rareChance.get();
        ultraRareChance = (Double)Config.CONFIG.ultraRareChance.get();
        legendaryChance = (Double)Config.CONFIG.legendaryChance.get();
        archaicChance = (Double)Config.CONFIG.archaicChance.get();
        basicDamage = (Double)Config.CONFIG.basicDamage.get();
        uncommonDamage = (Double)Config.CONFIG.uncommonDamage.get();
        rareDamage = (Double)Config.CONFIG.rareDamage.get();
        ultraRareDamage = (Double)Config.CONFIG.ultraRareDamage.get();
        legendaryDamage = (Double)Config.CONFIG.legendaryDamage.get();
        archaicDamage = (Double)Config.CONFIG.archaicDamage.get();
    }

    private static List<Item> parseItemList(List<String> lst) {
        ArrayList<Item> exp = new ArrayList<Item>(lst.size());
        for (String s : lst) {
            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
            if (i == null || i == Items.field_190931_a) {
                EnhancedArmaments.LOGGER.error("Invalid config entry {} will be ignored from blacklist.", (Object)s);
                continue;
            }
            exp.add(i);
        }
        return exp;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CFile::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (CFile)specPair.getLeft();
    }

    public static class CFile {
        public ForgeConfigSpec.ConfigValue<Integer> maxLevel;
        public ForgeConfigSpec.ConfigValue<Integer> level1Experience;
        public ForgeConfigSpec.ConfigValue<Double> experienceMultiplier;
        public ForgeConfigSpec.BooleanValue showDurabilityInTooltip;
        public ForgeConfigSpec.ConfigValue<List<String>> itemBlacklist;
        public ForgeConfigSpec.ConfigValue<List<String>> itemWhitelist;
        public ForgeConfigSpec.ConfigValue<List<String>> extraItems;
        public ForgeConfigSpec.BooleanValue onlyModdedItems;
        public ForgeConfigSpec.BooleanValue fireAbility;
        public ForgeConfigSpec.BooleanValue frostAbility;
        public ForgeConfigSpec.BooleanValue poisonAbility;
        public ForgeConfigSpec.BooleanValue innateAbility;
        public ForgeConfigSpec.BooleanValue bombasticAbility;
        public ForgeConfigSpec.BooleanValue criticalpointAbility;
        public ForgeConfigSpec.BooleanValue illuminationAbility;
        public ForgeConfigSpec.BooleanValue etherealAbility;
        public ForgeConfigSpec.BooleanValue bloodthirstAbility;
        public ForgeConfigSpec.BooleanValue moltenAbility;
        public ForgeConfigSpec.BooleanValue frozenAbility;
        public ForgeConfigSpec.BooleanValue toxicAbility;
        public ForgeConfigSpec.BooleanValue adrenalineAbility;
        public ForgeConfigSpec.BooleanValue beastialAbility;
        public ForgeConfigSpec.BooleanValue remedialAbility;
        public ForgeConfigSpec.BooleanValue hardenedAbility;
        public ForgeConfigSpec.ConfigValue<Double> firechance;
        public ForgeConfigSpec.ConfigValue<Double> frostchance;
        public ForgeConfigSpec.ConfigValue<Double> poisonchance;
        public ForgeConfigSpec.ConfigValue<Double> innatechance;
        public ForgeConfigSpec.ConfigValue<Double> bombasticchance;
        public ForgeConfigSpec.ConfigValue<Double> criticalpointchance;
        public ForgeConfigSpec.ConfigValue<Double> moltenchance;
        public ForgeConfigSpec.ConfigValue<Double> frozenchance;
        public ForgeConfigSpec.ConfigValue<Double> toxicchance;
        public ForgeConfigSpec.ConfigValue<Double> adrenalinechance;
        public ForgeConfigSpec.ConfigValue<Double> hardenedchance;
        public ForgeConfigSpec.ConfigValue<Double> basicChance;
        public ForgeConfigSpec.ConfigValue<Double> uncommonChance;
        public ForgeConfigSpec.ConfigValue<Double> rareChance;
        public ForgeConfigSpec.ConfigValue<Double> ultraRareChance;
        public ForgeConfigSpec.ConfigValue<Double> legendaryChance;
        public ForgeConfigSpec.ConfigValue<Double> archaicChance;
        public ForgeConfigSpec.ConfigValue<Double> basicDamage;
        public ForgeConfigSpec.ConfigValue<Double> uncommonDamage;
        public ForgeConfigSpec.ConfigValue<Double> rareDamage;
        public ForgeConfigSpec.ConfigValue<Double> ultraRareDamage;
        public ForgeConfigSpec.ConfigValue<Double> legendaryDamage;
        public ForgeConfigSpec.ConfigValue<Double> archaicDamage;

        public CFile(ForgeConfigSpec.Builder builder) {
            this.buildMain(builder);
            this.buildMisc(builder);
            this.buildAbilities(builder);
            this.buildAbilityChance(builder);
            this.buildRarities(builder);
            this.buildMultiplier(builder);
        }

        private void buildMain(ForgeConfigSpec.Builder builder) {
            builder.push("experience");
            this.maxLevel = builder.comment("Sets the maximum level cap for weapons and armor. Default: 10").define("maxLevel", (Object)10);
            this.level1Experience = builder.comment("The experience amount needed for the first level(1). Default: 100").define("level1Experience", (Object)100);
            this.experienceMultiplier = builder.comment("The experience multiplier for each level based on the first level experience. Default: 1.8").define("experienceMultiplier", (Object)1.8);
            builder.pop();
        }

        private void buildMisc(ForgeConfigSpec.Builder builder) {
            builder.push("miscellaneous");
            this.showDurabilityInTooltip = builder.comment("Determines whether or not durability will be displayed in tooltips. Default: true").define("showDurabilityInTooltip", true);
            this.itemBlacklist = builder.comment("Items in this blacklist will not gain the leveling systems. Useful for very powerful items or potential conflicts. Style should be 'modid:item'").define("itemBlacklist", new ArrayList());
            this.itemWhitelist = builder.comment("This is item whitelist, basically. If you don't want a whitelist, just leave this empty. If you want a whitelist, fill it with items you want. Style should be 'modid:item'").define("itemWhitelist", new ArrayList());
            this.extraItems = builder.comment("This is an extra item list to add custom support for such modded items. Be careful on this, it may crash if the item can't be enhanced. Style should be 'modid:item'").define("extraItems", new ArrayList());
            this.onlyModdedItems = builder.comment("Determines if the vanilla items won't be affected by this mod. Default: false").define("onlyModdedItems", false);
            builder.pop();
        }

        private void buildAbilities(ForgeConfigSpec.Builder builder) {
            builder.push("abilities");
            this.fireAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("fireAbility", true);
            this.frostAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("frostAbility", true);
            this.poisonAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("poisonAbility", true);
            this.innateAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("innateAbility", true);
            this.bombasticAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("bombasticAbility", true);
            this.criticalpointAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("criticalpointAbility", true);
            this.illuminationAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("illuminationAbility", true);
            this.etherealAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("etherealAbility", true);
            this.bloodthirstAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("bloodthirstAbility", true);
            this.moltenAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("moltenAbility", true);
            this.frozenAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("frozenAbility", true);
            this.moltenAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("moltenAbility", true);
            this.toxicAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("toxicAbility", true);
            this.adrenalineAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("adrenalineAbility", true);
            this.beastialAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("beastialAbility", true);
            this.remedialAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("remedialAbility", true);
            this.hardenedAbility = builder.comment("Determines whether or not the specific ability will be present in-game. Default: true").define("hardenedAbility", true);
            builder.pop();
        }

        private void buildAbilityChance(ForgeConfigSpec.Builder builder) {
            builder.push("abilitychances");
            this.firechance = builder.comment("Determines how rare the Fire ability will occur. (Higher values=lower occurance) Default: 4").define("firechance", (Object)4.0);
            this.frostchance = builder.comment("Determines how rare the Frost ability will occur. (Higher values=lower occurance) Default: 4").define("frostchance", (Object)4.0);
            this.poisonchance = builder.comment("Determines how rare the Poison ability will occur. (Higher values=lower occurance) Default: 4").define("poisonchance", (Object)4.0);
            this.innatechance = builder.comment("Determines how rare the Innate ability will occur. (Higher values=lower occurance) Default: 4").define("innatechance", (Object)4.0);
            this.bombasticchance = builder.comment("Determines how rare the Bombasitc ability will occur. (Higher values=lower occurance) Default: 4").define("bombasticchance", (Object)4.0);
            this.criticalpointchance = builder.comment("Determines how rare the Critical Point ability will occur. (Higher values=lower occurance) Default: 4").define("criticalpointchance", (Object)4.0);
            this.moltenchance = builder.comment("Determines how rare the Molten ability will occur. (Higher values=lower occurance) Default: 4").define("moltenchance", (Object)4.0);
            this.frozenchance = builder.comment("Determines how rare the Frozen ability will occur. (Higher values=lower occurance) Default: 4").define("frozenchance", (Object)4.0);
            this.toxicchance = builder.comment("Determines how rare the Toxic ability will occur. (Higher values=lower occurance) Default: 4").define("toxicchance", (Object)4.0);
            this.adrenalinechance = builder.comment("Determines how rare the Adrinalin ability will occur. (Higher values=lower occurance) Default: 4").define("adrenalinechance", (Object)4.0);
            this.hardenedchance = builder.comment("Determines how rare the Harden ability will occur. (Higher values=lower occurance) Default: 4").define("hardenedchance", (Object)4.0);
            builder.pop();
        }

        private void buildRarities(ForgeConfigSpec.Builder builder) {
            builder.push("rarities");
            this.basicChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.5").define("basicChance", (Object)0.5);
            this.uncommonChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.18").define("uncommonChance", (Object)0.18);
            this.rareChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.1").define("rareChance", (Object)0.1);
            this.ultraRareChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.05").define("ultraRareChance", (Object)0.05);
            this.legendaryChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.02").define("legendaryChance", (Object)0.02);
            this.archaicChance = builder.comment("Sets the chance the given rarity will be applied. Default: 0.01").define("archaicChance", (Object)0.01);
            builder.pop();
        }

        private void buildMultiplier(ForgeConfigSpec.Builder builder) {
            builder.push("multiplier");
            this.basicDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0").define("basicDamage", (Object)0.0);
            this.uncommonDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0.155").define("uncommonDamage", (Object)0.155);
            this.rareDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0.305").define("rareDamage", (Object)0.305);
            this.ultraRareDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0.38").define("ultraRareDamage", (Object)0.38);
            this.legendaryDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0.57").define("legendaryDamage", (Object)0.57);
            this.archaicDamage = builder.comment("Sets the effectiveness for the given rarity. Default: 0.81").define("archaicDamage", (Object)0.81);
            builder.pop();
        }
    }
}

