/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.essentials;

import com.jannesoon.enhancedarmaments.config.Config;
import com.jannesoon.enhancedarmaments.util.RandomCollection;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;

public enum Rarity {
    DEFAULT("", 0, 0.0, 0.0),
    BASIC(TextFormatting.WHITE, 0xFFFFFF, Config.basicChance, Config.basicDamage),
    UNCOMMON(TextFormatting.DARK_GREEN, 43520, Config.uncommonChance, Config.uncommonDamage),
    RARE(TextFormatting.AQUA, 0x55FFFF, Config.rareChance, Config.rareDamage),
    ULTRA_RARE(TextFormatting.DARK_PURPLE, 0xAA00AA, Config.ultraRareChance, Config.ultraRareDamage),
    LEGENDARY(TextFormatting.GOLD, 0xFFAA00, Config.legendaryChance, Config.legendaryDamage),
    ARCHAIC(TextFormatting.LIGHT_PURPLE, 0xFF55FF, Config.archaicChance, Config.archaicDamage);

    private String color;
    private int hex;
    private double weight;
    private double effect;
    private static final Rarity[] RARITIES;
    private static final RandomCollection<Rarity> RANDOM_RARITIES;

    private Rarity(Object color, int hex, double weight, double effect) {
        this.color = color.toString();
        this.hex = hex;
        this.weight = weight;
        this.effect = effect;
    }

    public static Rarity getRandomRarity(Random random) {
        return RANDOM_RARITIES.next(random);
    }

    public static Rarity getRarity(NBTTagCompound nbt) {
        return nbt != null && nbt.func_74764_b("RARITY") ? RARITIES[nbt.func_74762_e("RARITY")] : DEFAULT;
    }

    public void setRarity(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("RARITY", this.ordinal());
        }
    }

    public static void setRarity(NBTTagCompound nbt, String rarityName) {
        int rarity = Integer.parseInt(rarityName);
        nbt.func_74768_a("RARITY", rarity);
    }

    public String getName() {
        return this.toString();
    }

    public String getColor() {
        return this.color;
    }

    public int getHex() {
        return this.hex;
    }

    public double getEffect() {
        return this.effect;
    }

    static {
        RARITIES = Rarity.values();
        RANDOM_RARITIES = new RandomCollection();
        for (Rarity rarity : RARITIES) {
            if (!(rarity.weight > 0.0)) continue;
            RANDOM_RARITIES.add(rarity.weight, rarity);
        }
    }
}

