/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.event;

import com.google.common.collect.Multimap;
import com.jannesoon.enhancedarmaments.config.Config;
import com.jannesoon.enhancedarmaments.essentials.Ability;
import com.jannesoon.enhancedarmaments.essentials.Experience;
import com.jannesoon.enhancedarmaments.essentials.Rarity;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventItemTooltip {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addInformation(ItemTooltipEvent event) {
        NBTTagCompound nbt;
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (EAUtils.canEnhance(item) && Experience.isEnabled(nbt = NBTHelper.loadStackNBT(stack))) {
            Rarity rarity = Rarity.getRarity(nbt);
            int level = Experience.getLevel(nbt);
            int experience = Experience.getExperience(nbt);
            int maxExperience = Experience.getMaxLevelExp(level);
            this.changeTooltips(tooltip, stack, rarity);
            if (level >= Config.maxLevel) {
                tooltip.add(new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + TextFormatting.RED + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0])));
            } else {
                tooltip.add(new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.level", (Object[])new Object[0]) + ": " + TextFormatting.WHITE + level));
            }
            if (level >= Config.maxLevel) {
                tooltip.add(new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)"enhancedarmaments.misc.max", (Object[])new Object[0])));
            } else {
                tooltip.add(new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.experience", (Object[])new Object[0]) + ": " + experience + " / " + maxExperience));
            }
            if (Config.showDurabilityInTooltip) {
                tooltip.add(new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.durability", (Object[])new Object[0]) + ": " + (stack.func_77958_k() - stack.func_77952_i()) + " / " + stack.func_77958_k()));
            }
            tooltip.add(new TextComponentString(""));
            if (GuiScreen.func_146272_n()) {
                tooltip.add(new TextComponentString(rarity.getColor() + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities", (Object[])new Object[0])));
                tooltip.add(new TextComponentString(""));
                if (EAUtils.canEnhanceWeapon(item)) {
                    for (Ability ability : Ability.WEAPON_ABILITIES) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add(new TextComponentTranslation("-" + ability.getColor() + ability.getName(nbt), new Object[0]));
                    }
                } else if (EAUtils.canEnhanceArmor(item)) {
                    for (Ability ability : Ability.ARMOR_ABILITIES) {
                        if (!ability.hasAbility(nbt)) continue;
                        tooltip.add(new TextComponentTranslation("-" + ability.getColor() + ability.getName(nbt), new Object[0]));
                    }
                }
            } else {
                tooltip.add(new TextComponentString(rarity.getColor() + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"enhancedarmaments.misc.abilities.shift", (Object[])new Object[0])));
            }
        }
    }

    private void changeTooltips(List<ITextComponent> tooltip, ItemStack stack, Rarity rarity) {
        tooltip.set(0, (ITextComponent)new TextComponentString(stack.func_200301_q().func_150254_d() + rarity.getColor() + " (" + TextFormatting.ITALIC + I18n.func_135052_a((String)("enhancedarmaments.rarity." + rarity.getName()), (Object[])new Object[0]) + ")"));
        if (EAUtils.containsString(tooltip, "When in main hand:") && !(stack.func_77973_b() instanceof ItemBow)) {
            Multimap map = stack.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
            Collection damageCollection = map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            double damage = (damageModifier.func_111164_d() + 1.0) * rarity.getEffect() + damageModifier.func_111164_d() + 1.0;
            String d = String.format("%.1f", damage);
            if (rarity.getEffect() != 0.0) {
                tooltip.set(EAUtils.lineContainsString(tooltip, "When in main hand:") + 2, (ITextComponent)new TextComponentString(rarity.getColor() + " " + d + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"enhancedarmaments.misc.tooltip.attackdamage", (Object[])new Object[0])));
            }
        }
        if (EAUtils.containsString(tooltip, "When on head:") || EAUtils.containsString(tooltip, "When on body:") || EAUtils.containsString(tooltip, "When on legs:") || EAUtils.containsString(tooltip, "When on feet:")) {
            String p = String.format("%.1f", 100.0 - 100.0 / (1.0 + rarity.getEffect() / 5.0));
            float percentage = Float.valueOf(p).floatValue();
            int line = 2;
            if (EAUtils.containsString(tooltip, "When on head:")) {
                line = EAUtils.lineContainsString(tooltip, "When on head:");
            }
            if (EAUtils.containsString(tooltip, "When on body:")) {
                line = EAUtils.lineContainsString(tooltip, "When on body:");
            }
            if (EAUtils.containsString(tooltip, "When on legs:")) {
                line = EAUtils.lineContainsString(tooltip, "When on legs:");
            }
            if (EAUtils.containsString(tooltip, "When on feet:")) {
                line = EAUtils.lineContainsString(tooltip, "When on feet:");
            }
            if (percentage != 0.0f) {
                tooltip.add(line + 1, (ITextComponent)new TextComponentString(" " + TextFormatting.BLUE + "+" + rarity.getColor() + percentage + TextFormatting.BLUE + "% " + I18n.func_135052_a((String)"enhancedarmaments.misc.rarity.armorreduction", (Object[])new Object[0])));
            }
        }
        if (EAUtils.canEnhanceRanged(stack.func_77973_b()) && rarity.getEffect() != 0.0) {
            String b = String.format("%.1f", rarity.getEffect() / 3.0 * 100.0);
            tooltip.add(1, (ITextComponent)new TextComponentString(I18n.func_135052_a((String)"enhancedarmaments.misc.rarity.arrowpercentage", (Object[])new Object[0]) + " " + rarity.getColor() + "+" + b + "%"));
        }
    }
}

