/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.event;

import com.jannesoon.enhancedarmaments.config.Config;
import com.jannesoon.enhancedarmaments.essentials.Ability;
import com.jannesoon.enhancedarmaments.essentials.Experience;
import com.jannesoon.enhancedarmaments.event.EventLivingHurt;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventLivingDeath {
    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack stack = EventLivingHurt.bowfriendlyhand == null ? player.func_184586_b(player.func_184600_cs()) : player.func_184586_b(EventLivingHurt.bowfriendlyhand);
            if (stack != ItemStack.field_190927_a && EAUtils.canEnhanceMelee(stack.func_77973_b())) {
                NBTTagCompound nbt2 = NBTHelper.loadStackNBT(stack);
                if (nbt2 != null && nbt2.func_74764_b("EA_ENABLED")) {
                    if (Ability.ETHEREAL.hasAbility(nbt2)) {
                        player.field_71071_by.func_70448_g().func_196085_b(player.field_71071_by.func_70448_g().func_77952_i() - Ability.ETHEREAL.getLevel(nbt2) * 2);
                    }
                    EventLivingDeath.addBonusExperience(event, nbt2);
                    EventLivingDeath.updateLevel(player, stack, nbt2);
                    NBTHelper.saveStackNBT(stack, nbt2);
                }
            } else if (stack != ItemStack.field_190927_a && EAUtils.canEnhanceRanged(stack.func_77973_b()) && (nbt = NBTHelper.loadStackNBT(stack)) != null && nbt.func_74764_b("EA_ENABLED")) {
                if (Ability.ETHEREAL.hasAbility(nbt)) {
                    player.field_71071_by.func_70448_g().func_196085_b(player.field_71071_by.func_70448_g().func_77952_i() - (Ability.ETHEREAL.getLevel(nbt) * 2 + 1));
                }
                EventLivingDeath.addBonusExperience(event, nbt);
                EventLivingDeath.updateLevel(player, stack, nbt);
            }
        } else if (event.getSource().func_76346_g() instanceof EntityArrow) {
            NBTTagCompound nbt;
            ItemStack stack;
            EntityPlayer player;
            EntityArrow arrow = (EntityArrow)event.getSource().func_76346_g();
            if (EAUtils.getEntityByUniqueId(arrow.field_70250_c) instanceof EntityPlayer && EAUtils.getEntityByUniqueId(arrow.field_70250_c) != null && (player = (EntityPlayer)EAUtils.getEntityByUniqueId(arrow.field_70250_c)) != null && (stack = player.field_71071_by.func_70448_g()) != ItemStack.field_190927_a && (nbt = NBTHelper.loadStackNBT(stack)) != null) {
                EventLivingDeath.addBonusExperience(event, nbt);
                EventLivingDeath.updateLevel(player, stack, nbt);
            }
        }
    }

    private static void addBonusExperience(LivingDeathEvent event, NBTTagCompound nbt) {
        if (Experience.getLevel(nbt) < Config.maxLevel && event.getEntityLiving() != null) {
            EntityLivingBase target = event.getEntityLiving();
            int bonusExperience = 0;
            if (target.func_110138_aP() < 10.0f) {
                bonusExperience = 3;
            } else if (target.func_110138_aP() > 9.0f && target.func_110138_aP() < 20.0f) {
                bonusExperience = 6;
            } else if (target.func_110138_aP() > 19.0f && target.func_110138_aP() < 50.0f) {
                bonusExperience = 15;
            } else if (target.func_110138_aP() > 49.0f && target.func_110138_aP() < 100.0f) {
                bonusExperience = 50;
            } else if (target.func_110138_aP() > 99.0f) {
                bonusExperience = 70;
            }
            Experience.setExperience(nbt, Experience.getExperience(nbt) + bonusExperience);
        }
    }

    private static void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
    }
}

