/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.event;

import com.google.common.collect.Multimap;
import com.jannesoon.enhancedarmaments.config.Config;
import com.jannesoon.enhancedarmaments.essentials.Ability;
import com.jannesoon.enhancedarmaments.essentials.Experience;
import com.jannesoon.enhancedarmaments.essentials.Rarity;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventLivingHurt {
    public static EnumHand bowfriendlyhand;

    @SubscribeEvent
    public void onArrowHit(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof EntityArrow && EAUtils.getEntityByUniqueId(((EntityArrow)event.getEntity()).field_70250_c) instanceof EntityPlayer && EAUtils.getEntityByUniqueId(((EntityArrow)event.getEntity()).field_70250_c) != null) {
            EntityPlayer player = (EntityPlayer)EAUtils.getEntityByUniqueId(((EntityArrow)event.getEntity()).field_70250_c);
            if (event.getRayTraceResult().field_72308_g == null && player != null) {
                bowfriendlyhand = player.func_184600_cs();
            }
        }
    }

    @SubscribeEvent
    public void onArrowShoot(ArrowLooseEvent event) {
        bowfriendlyhand = event.getEntityPlayer().func_184600_cs();
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer && !(event.getSource().func_76346_g() instanceof FakePlayer)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            EntityLivingBase target = event.getEntityLiving();
            ItemStack stack = bowfriendlyhand == null ? player.func_184586_b(player.func_184600_cs()) : player.func_184586_b(bowfriendlyhand);
            if (stack != ItemStack.field_190927_a && EAUtils.canEnhanceWeapon(stack.func_77973_b()) && (nbt = NBTHelper.loadStackNBT(stack)) != null && nbt.func_74764_b("EA_ENABLED")) {
                this.updateExperience(nbt, event.getAmount());
                this.useRarity(event, stack, nbt);
                this.useWeaponAbilities(event, player, target, nbt);
                this.updateLevel(player, stack, nbt);
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Entity target = event.getSource().func_76346_g();
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                NBTTagCompound nbt;
                if (stack == null || !EAUtils.canEnhanceArmor(stack.func_77973_b()) || (nbt = NBTHelper.loadStackNBT(stack)) == null || !nbt.func_74764_b("EA_ENABLED")) continue;
                if (EAUtils.isDamageSourceAllowed(event.getSource())) {
                    if (event.getAmount() < player.func_110138_aP() + (float)player.func_70658_aO()) {
                        this.updateExperience(nbt, event.getAmount());
                    } else {
                        this.updateExperience(nbt, 1.0f);
                    }
                    this.updateLevel(player, stack, nbt);
                }
                this.useRarity(event, stack, nbt);
                this.useArmorAbilities(event, player, target, nbt);
            }
        }
    }

    private void updateExperience(NBTTagCompound nbt, float dealedDamage) {
        if (Experience.getLevel(nbt) < Config.maxLevel) {
            Experience.setExperience(nbt, Experience.getExperience(nbt) + 1 + (int)dealedDamage / 4);
        }
    }

    private void useRarity(LivingHurtEvent event, ItemStack stack, NBTTagCompound nbt) {
        Rarity rarity = Rarity.getRarity(nbt);
        if (rarity != Rarity.DEFAULT) {
            if (EAUtils.canEnhanceMelee(stack.func_77973_b())) {
                Multimap map = stack.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack);
                Collection damageCollection = map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
                double damage = damageModifier.func_111164_d();
                event.setAmount((float)((double)event.getAmount() + damage * rarity.getEffect()));
            } else if (EAUtils.canEnhanceRanged(stack.func_77973_b())) {
                float newdamage = (float)((double)event.getAmount() + (double)event.getAmount() * rarity.getEffect() / 3.0);
                event.setAmount(newdamage);
            } else if (EAUtils.canEnhanceArmor(stack.func_77973_b())) {
                event.setAmount((float)((double)event.getAmount() / (1.0 + rarity.getEffect() / 5.0)));
            }
        }
    }

    private void useWeaponAbilities(LivingHurtEvent event, EntityPlayer player, EntityLivingBase target, NBTTagCompound nbt) {
        if (target != null) {
            double multiplier;
            if (Ability.FIRE.hasAbility(nbt) && (int)(Math.random() * Config.firechance) == 0) {
                multiplier = (Ability.FIRE.getLevel(nbt) + Ability.FIRE.getLevel(nbt) * 4) / 4;
                target.func_70015_d((int)multiplier);
            }
            if (Ability.FROST.hasAbility(nbt) && (int)(Math.random() * Config.frostchance) == 0) {
                multiplier = (Ability.FROST.getLevel(nbt) + Ability.FROST.getLevel(nbt) * 4) / 3;
                target.func_195064_c(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 * multiplier), 10));
            }
            if (Ability.POISON.hasAbility(nbt) && (int)(Math.random() * Config.poisonchance) == 0) {
                multiplier = (Ability.POISON.getLevel(nbt) + Ability.POISON.getLevel(nbt) * 4) / 2;
                target.func_195064_c(new PotionEffect(MobEffects.field_76436_u, (int)(20.0 * multiplier), Ability.POISON.getLevel(nbt)));
            }
            if (Ability.INNATE.hasAbility(nbt) && (int)(Math.random() * Config.innatechance) == 0) {
                multiplier = (Ability.INNATE.getLevel(nbt) + Ability.INNATE.getLevel(nbt) * 4) / 3;
                target.func_195064_c(new PotionEffect(MobEffects.field_82731_v, (int)(20.0 * multiplier), Ability.INNATE.getLevel(nbt)));
            }
            if (Ability.BOMBASTIC.hasAbility(nbt) && (int)(Math.random() * Config.bombasticchance) == 0) {
                double multiplierD = (Ability.BOMBASTIC.getLevel(nbt) + Ability.BOMBASTIC.getLevel(nbt) * 4) / 4;
                float multiplier2 = (float)multiplierD;
                World world = target.func_130014_f_();
                if (!(target instanceof EntityAnimal)) {
                    world.func_72876_a((Entity)target, target.field_70142_S, target.field_70137_T, target.field_70136_U, multiplier2, true);
                }
            }
            if (Ability.CRITICAL_POINT.hasAbility(nbt) && (int)(Math.random() * Config.criticalpointchance) == 0) {
                float multiplier3 = 0.0f;
                if (Ability.CRITICAL_POINT.getLevel(nbt) == 1) {
                    multiplier3 = 0.17f;
                } else if (Ability.CRITICAL_POINT.getLevel(nbt) == 2) {
                    multiplier3 = 0.34f;
                } else if (Ability.CRITICAL_POINT.getLevel(nbt) == 3) {
                    multiplier3 = 0.51f;
                }
                float damage = target.func_110138_aP() * multiplier3;
                event.setAmount(event.getAmount() + damage);
            }
            if (Ability.ILLUMINATION.hasAbility(nbt)) {
                target.func_195064_c(new PotionEffect(MobEffects.field_76437_t, 100, Ability.ILLUMINATION.getLevel(nbt)));
            }
            if (Ability.BLOODTHIRST.hasAbility(nbt)) {
                float addition = event.getAmount() * (float)(Ability.BLOODTHIRST.getLevel(nbt) * 12) / 100.0f;
                player.func_70606_j(player.func_110143_aJ() + addition);
            }
        }
    }

    private void useArmorAbilities(LivingHurtEvent event, EntityPlayer player, Entity target, NBTTagCompound nbt) {
        if (target != null) {
            double multiplier;
            EntityLivingBase realTarget;
            if (Ability.MOLTEN.hasAbility(nbt) && (int)(Math.random() * Config.moltenchance) == 0 && target instanceof EntityLivingBase) {
                realTarget = (EntityLivingBase)target;
                multiplier = (Ability.MOLTEN.getLevel(nbt) + Ability.MOLTEN.getLevel(nbt) * 5) / 4;
                realTarget.func_70015_d((int)multiplier);
            }
            if (Ability.FROZEN.hasAbility(nbt) && (int)(Math.random() * Config.frozenchance) == 0 && target instanceof EntityLivingBase) {
                realTarget = (EntityLivingBase)target;
                multiplier = (Ability.FROZEN.getLevel(nbt) + Ability.FROZEN.getLevel(nbt) * 5) / 6;
                realTarget.func_195064_c(new PotionEffect(MobEffects.field_76421_d, (int)(20.0 * multiplier), 10));
            }
            if (Ability.TOXIC.hasAbility(nbt) && (int)(Math.random() * Config.toxicchance) == 0 && target instanceof EntityLivingBase) {
                realTarget = (EntityLivingBase)target;
                multiplier = (Ability.TOXIC.getLevel(nbt) + Ability.TOXIC.getLevel(nbt) * 4) / 4;
                realTarget.func_195064_c(new PotionEffect(MobEffects.field_76436_u, (int)(20.0 * multiplier), Ability.TOXIC.getLevel(nbt)));
            }
            if (Ability.ADRENALINE.hasAbility(nbt) && (int)(Math.random() * Config.adrenalinechance) == 0) {
                double multiplier2 = (Ability.ADRENALINE.getLevel(nbt) + Ability.ADRENALINE.getLevel(nbt) * 5) / 3;
                player.func_195064_c(new PotionEffect(MobEffects.field_76428_l, (int)(20.0 * multiplier2), Ability.ADRENALINE.getLevel(nbt)));
            }
            if (Ability.BEASTIAL.hasAbility(nbt) && player.func_110143_aJ() <= player.func_110138_aP() * 0.2f) {
                player.func_195064_c(new PotionEffect(MobEffects.field_76420_g, 140, 0));
            }
            if (Ability.HARDENED.hasAbility(nbt) && (int)(Math.random() * Config.hardenedchance) == 0) {
                event.setAmount(0.0f);
            }
        }
    }

    private void updateLevel(EntityPlayer player, ItemStack stack, NBTTagCompound nbt) {
        int level = Experience.getNextLevel(player, stack, nbt, Experience.getLevel(nbt), Experience.getExperience(nbt));
        Experience.setLevel(nbt, level);
        NBTHelper.saveStackNBT(stack, nbt);
    }
}

