/*
 * Decompiled with CFR 0.152.
 */
package com.jannesoon.enhancedarmaments.event;

import com.jannesoon.enhancedarmaments.config.Config;
import com.jannesoon.enhancedarmaments.essentials.Ability;
import com.jannesoon.enhancedarmaments.essentials.Experience;
import com.jannesoon.enhancedarmaments.essentials.Rarity;
import com.jannesoon.enhancedarmaments.util.EAUtils;
import com.jannesoon.enhancedarmaments.util.NBTHelper;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EventLivingUpdate {
    private int count = 0;

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()) != null) {
            NonNullList main = player.field_71071_by.field_70462_a;
            if (!player.field_70170_p.field_72995_K) {
                for (ItemStack stack : player.field_71071_by.field_70460_b) {
                    if (stack == null || !EAUtils.canEnhanceArmor(stack.func_77973_b())) continue;
                    NBTTagCompound nbt = stack.func_77978_p();
                    float heal = Ability.REMEDIAL.getLevel(nbt);
                    if (!Ability.REMEDIAL.hasAbility(nbt)) continue;
                    if (this.count < 120) {
                        ++this.count;
                        continue;
                    }
                    this.count = 0;
                    player.func_70691_i(heal);
                }
                for (ItemStack stack : main) {
                    NBTTagCompound nbt;
                    Item item;
                    if (stack == ItemStack.field_190927_a || !EAUtils.canEnhance(item = stack.func_77973_b()) || (nbt = NBTHelper.loadStackNBT(stack)) == null || Experience.isEnabled(nbt)) continue;
                    boolean okay = true;
                    for (int j = 0; j < Config.itemBlacklist.size(); ++j) {
                        if (!Config.itemBlacklist.get(j).equals(stack.func_77973_b().getRegistryName().func_110623_a())) continue;
                        okay = false;
                    }
                    if (Config.itemWhitelist.size() != 0) {
                        okay = false;
                        for (int k = 0; k < Config.itemWhitelist.size(); ++k) {
                            if (!Config.itemWhitelist.get(k).equals(stack.func_77973_b().getRegistryName().func_110623_a())) continue;
                            okay = true;
                        }
                    }
                    if (!okay) continue;
                    Experience.enable(nbt, true);
                    Rarity rarity = Rarity.getRarity(nbt);
                    Random rand = player.field_70170_p.field_73012_v;
                    if (rarity != Rarity.DEFAULT) continue;
                    rarity = Rarity.getRandomRarity(rand);
                    rarity.setRarity(nbt);
                    NBTHelper.saveStackNBT(stack, nbt);
                }
            }
        }
    }
}

