/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins;

import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.cmd.CommandClearWorld;
import com.alcatrazescapee.oreveins.cmd.CommandFindVeins;
import com.alcatrazescapee.oreveins.cmd.CommandVeinInfo;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.alcatrazescapee.oreveins.world.WorldGenReplacer;
import com.alcatrazescapee.oreveins.world.WorldGenVeins;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;

@Mod(modid="oreveins", version="2.0.15", dependencies="required-after:forge@[14.23.2.2611,15.0.0.0);", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class OreVeins {
    public static final String MOD_ID = "oreveins";
    public static final String MOD_NAME = "Ore Veins";
    public static final String VERSION = "2.0.15";
    private static final String FORGE_MIN = "14.23.2.2611";
    private static final String FORGE_MAX = "15.0.0.0";
    public static final String DEPENDENCIES = "required-after:forge@[14.23.2.2611,15.0.0.0);";
    private static Logger log;

    public static Logger getLog() {
        return log;
    }

    public OreVeins() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            WorldGenVeins.resetChunkRadius();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        log.debug("If you can see this, debug logging is working :)");
        VeinRegistry.preInit(event.getModConfigurationDirectory());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenVeins(), (int)1);
        MinecraftForge.ORE_GEN_BUS.register((Object)new WorldGenReplacer());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        VeinRegistry.reloadVeins();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (OreVeinsConfig.DEBUG_COMMANDS) {
            event.registerServerCommand((ICommand)new CommandClearWorld());
            event.registerServerCommand((ICommand)new CommandVeinInfo());
            event.registerServerCommand((ICommand)new CommandFindVeins());
        }
    }
}

