/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.api;

import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.api.AbstractVein;
import com.alcatrazescapee.oreveins.api.ICondition;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.vein.Indicator;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

@ParametersAreNonnullByDefault
public abstract class AbstractVeinType<V extends AbstractVein<?>>
implements IVeinType<V> {
    protected int count = 1;
    protected int rarity = 10;
    @SerializedName(value="min_y")
    protected int minY = 16;
    @SerializedName(value="max_y")
    protected int maxY = 64;
    @SerializedName(value="use_relative_y")
    protected boolean useRelativeY = false;
    @SerializedName(value="vertical_size")
    protected int verticalSize = 8;
    @SerializedName(value="horizontal_size")
    protected int horizontalSize = 15;
    protected float density = 20.0f;
    @SerializedName(value="dimensions_is_whitelist")
    protected boolean dimensionIsWhitelist = true;
    @SerializedName(value="biomes_is_whitelist")
    protected boolean biomesIsWhitelist = true;
    @SerializedName(value="stone")
    private List<IBlockState> stoneStates = null;
    @SerializedName(value="ore")
    private IWeightedList<IBlockState> oreStates = null;
    private List<String> biomes = null;
    private List<Integer> dimensions = null;
    private List<ICondition> conditions = null;
    private IWeightedList<Indicator> indicator = null;

    @Override
    @Nonnull
    public IBlockState getStateToGenerate(Random rand) {
        return this.oreStates.get(rand);
    }

    @Override
    @Nonnull
    public Collection<IBlockState> getOreStates() {
        return this.oreStates.values();
    }

    @Override
    @Nullable
    public Indicator getIndicator(Random random) {
        return this.indicator != null ? this.indicator.get(random) : null;
    }

    @Override
    public boolean canGenerateAt(World world, BlockPos pos) {
        IBlockState stoneState = world.func_180495_p(pos);
        if (this.stoneStates.contains(stoneState)) {
            if (this.conditions != null) {
                for (ICondition condition : this.conditions) {
                    if (condition.test(world, pos)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean inRange(V vein, int xOffset, int zOffset) {
        return (float)(xOffset * xOffset + zOffset * zOffset) < (float)(this.horizontalSize * this.horizontalSize) * ((AbstractVein)vein).getSize();
    }

    @Override
    public boolean matchesDimension(int id) {
        if (this.dimensions == null) {
            return id == 0;
        }
        for (int i : this.dimensions) {
            if (id != i) continue;
            return this.dimensionIsWhitelist;
        }
        return !this.dimensionIsWhitelist;
    }

    @Override
    public boolean matchesBiome(Biome biome) {
        if (this.biomes == null) {
            return true;
        }
        for (String s : this.biomes) {
            String biomeName = biome.getRegistryName().func_110623_a();
            if (biomeName.equals(s)) {
                return this.biomesIsWhitelist;
            }
            for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                if (!s.equalsIgnoreCase(type.getName())) continue;
                return this.biomesIsWhitelist;
            }
        }
        return !this.biomesIsWhitelist;
    }

    @Override
    public boolean isValid() {
        return this.oreStates != null && !this.oreStates.isEmpty() && this.stoneStates != null && !this.stoneStates.isEmpty() && (this.indicator == null || !this.indicator.isEmpty() && this.indicator.values().stream().map(Indicator::isValid).reduce((x, y) -> x != false && y != false).orElse(false) != false) && this.maxY > this.minY && (this.minY >= 0 || this.useRelativeY) && this.count > 0 && this.rarity > 0 && this.verticalSize > 0 && this.horizontalSize > 0 && this.density > 0.0f;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public String toString() {
        return String.format("[%s: Count: %d, Rarity: %d, Y: %d - %d, Size: %d / %d, Density: %2.2f, Ores: %s, Stones: %s]", VeinRegistry.getName(this), this.count, this.rarity, this.minY, this.maxY, this.horizontalSize, this.verticalSize, Float.valueOf(this.density), this.oreStates, this.stoneStates);
    }

    protected final BlockPos defaultStartPos(int chunkX, int chunkZ, Random rand) {
        int spawnRange = this.maxY - this.minY;
        int minRange = this.minY;
        if (OreVeinsConfig.AVOID_VEIN_CUTOFFS) {
            if (this.verticalSize * 2 < spawnRange) {
                spawnRange -= this.verticalSize * 2;
                minRange += this.verticalSize;
            } else {
                minRange = this.minY + (this.maxY - this.minY) / 2;
                spawnRange = 1;
            }
        }
        return new BlockPos(chunkX * 16 + rand.nextInt(16), minRange + rand.nextInt(spawnRange), chunkZ * 16 + rand.nextInt(16));
    }

    @Override
    public int getRarity() {
        return this.rarity;
    }

    @Override
    public int getChunkRadius() {
        return 1 + (this.horizontalSize >> 4);
    }

    @Override
    public boolean useRelativeY() {
        return this.useRelativeY;
    }
}

