/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.cmd;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class CommandClearWorld
extends CommandBase {
    private static final Set<IBlockState> VEIN_STATES = new HashSet<IBlockState>();

    public static void resetVeinStates() {
        VeinRegistry.getVeins().stream().map(IVeinType::getOreStates).forEach(VEIN_STATES::addAll);
    }

    @Nonnull
    public String func_71517_b() {
        return "clearworld";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "/clearworld <radius> -> Removes all blocks that are NOT part of an ore vein";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException("1 argument required.", new Object[0]);
        }
        if (sender.func_174793_f() == null) {
            throw new WrongUsageException("Can only be used by a player", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Clearing world... " + TextFormatting.RED + "Lag incoming"));
        int radius = CommandClearWorld.func_175764_a((String)args[0], (int)1, (int)250);
        World world = sender.func_130014_f_();
        BlockPos center = new BlockPos(sender.func_174793_f());
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = 255 - center.func_177956_o(); y >= -center.func_177956_o(); --y) {
                    BlockPos pos = center.func_177982_a(x, y, z);
                    if (VEIN_STATES.contains(world.func_180495_p(pos)) || world.func_180495_p(pos) == air) continue;
                    world.func_180501_a(pos, air, 18);
                }
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Done."));
    }
}

