/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.cmd;

import com.alcatrazescapee.oreveins.api.IVein;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import com.alcatrazescapee.oreveins.world.WorldGenVeins;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

@ParametersAreNonnullByDefault
public class CommandFindVeins
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "findveins";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "/findveins [all|<vein name>] <radius> -> Finds all instances of a specific vein, or all veins within a certian chunk radius";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 2) {
            throw new WrongUsageException("2 arguments required.", new Object[0]);
        }
        if (sender.func_174793_f() == null) {
            throw new WrongUsageException("Can only be used by a player", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Veins Found: "));
        int radius = CommandFindVeins.func_175764_a((String)args[1], (int)1, (int)1000);
        List<IVein> veins = WorldGenVeins.getNearbyVeins(sender.func_174793_f().field_70176_ah, sender.func_174793_f().field_70164_aj, sender.func_130014_f_().func_72905_C(), radius);
        if (!args[0].equals("all")) {
            IVeinType type = VeinRegistry.getVein(args[0]);
            if (type == null) {
                throw new WrongUsageException("Vein supplied does not match 'all' or any valid vein names. Use /veininfo to see valid vein names", new Object[0]);
            }
            veins.removeIf(x -> x.getType() != type);
        }
        veins.forEach(x -> sender.func_145747_a((ITextComponent)new TextComponentString("> Vein: " + x.toString())));
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandFindVeins.func_175762_a((String[])args, VeinRegistry.getNames());
        }
        return Collections.emptyList();
    }
}

