/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.cmd;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

@ParametersAreNonnullByDefault
public class CommandVeinInfo
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "veininfo";
    }

    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return "/veininfo [all|<vein name>] -> lists info about registered veins. Use 'all' to see all registered veins";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException("Requires one argument: " + this.func_71518_a(sender), new Object[0]);
        }
        if (sender.func_174793_f() == null) {
            throw new WrongUsageException("Can only be used by a player", new Object[0]);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Registered Veins: "));
        if (args[0].equals("all")) {
            VeinRegistry.getNames().forEach(x -> sender.func_145747_a((ITextComponent)new TextComponentString("> " + x)));
        } else {
            IVeinType type = VeinRegistry.getVein(args[0]);
            if (type == null) {
                throw new WrongUsageException("Vein supplied does not match any valid vein names. Use /veininfo all to see valid vein names", new Object[0]);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("> " + type.toString()));
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandVeinInfo.func_175762_a((String[])args, VeinRegistry.getNames());
        }
        return Collections.emptyList();
    }
}

