/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.conditions;

import com.alcatrazescapee.oreveins.api.ICondition;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class ConditionTouching
implements ICondition {
    private Predicate<IBlockState> blockMatcher;
    private int minMatches;
    private int maxMatches;

    private ConditionTouching(Predicate<IBlockState> blockMatcher, int minMatches, int maxMatches) {
        this.blockMatcher = blockMatcher;
        this.minMatches = minMatches;
        this.maxMatches = maxMatches;
    }

    @Override
    public boolean test(World world, BlockPos pos) {
        int matchCount = 0;
        for (EnumFacing face : EnumFacing.values()) {
            if (this.blockMatcher.test(world.func_180495_p(pos.func_177972_a(face)))) {
                ++matchCount;
            }
            if (this.minMatches > matchCount || matchCount > this.maxMatches) continue;
            return true;
        }
        return false;
    }

    public static final class Factory
    implements ICondition.Factory<ConditionTouching> {
        @Override
        @Nonnull
        public ConditionTouching parse(JsonObject json, JsonDeserializationContext context) {
            IBlockState stateToMatch = (IBlockState)context.deserialize(json.get("block"), IBlockState.class);
            Predicate<IBlockState> blockMatcher = state -> state == stateToMatch;
            int min = JsonUtils.func_151208_a((JsonObject)json, (String)"min", (int)1);
            int max = JsonUtils.func_151208_a((JsonObject)json, (String)"max", (int)8);
            return new ConditionTouching(blockMatcher, min, max);
        }
    }
}

