/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class BlockStateDeserializer
implements JsonDeserializer<IBlockState> {
    private static IBlockState getBlockState(String name, int meta) throws JsonParseException {
        Block block = Block.func_149684_b((String)name);
        if (block == null) {
            throw new JsonParseException("Unrecognized Block: " + name);
        }
        return meta == -1 ? block.func_176223_P() : block.func_176203_a(meta);
    }

    private static IBlockState getOre(String oreName) throws JsonParseException {
        NonNullList ores = OreDictionary.getOres((String)oreName, (boolean)false);
        for (ItemStack oreStack : ores) {
            Block block;
            if (oreStack.func_190926_b() || (block = Block.func_149634_a((Item)oreStack.func_77973_b())) == Blocks.field_150350_a) continue;
            int meta = oreStack.func_77960_j();
            return block.func_176203_a(meta);
        }
        throw new JsonParseException("Unrecognized Ore Dictionary Name: " + oreName);
    }

    public IBlockState deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("block")) {
                String name = obj.get("block").getAsString();
                if (obj.has("meta")) {
                    return BlockStateDeserializer.getBlockState(name, obj.get("meta").getAsInt());
                }
                return BlockStateDeserializer.getBlockState(name, -1);
            }
            if (obj.has("ore")) {
                return BlockStateDeserializer.getOre(obj.get("ore").getAsString());
            }
        } else if (json.isJsonPrimitive()) {
            String name = json.getAsString();
            if (name.startsWith("ore:")) {
                return BlockStateDeserializer.getOre(name.substring(4));
            }
            return BlockStateDeserializer.getBlockState(name, -1);
        }
        throw new JsonParseException("Unable to parse IBlockState");
    }
}

