/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.api.ICondition;
import com.alcatrazescapee.oreveins.conditions.ConditionTouching;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ConditionDeserializer
implements JsonDeserializer<ICondition> {
    private final Map<String, ICondition.Factory<? extends ICondition>> types = new HashMap<String, ICondition.Factory<? extends ICondition>>();

    public ConditionDeserializer() {
        this.types.put("touching", new ConditionTouching.Factory());
    }

    public ICondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String conditionType = obj.get("type").getAsString();
        if (this.types.containsKey(conditionType)) {
            return this.types.get(conditionType).parse(obj, context);
        }
        throw new JsonParseException("Unknown condition type " + conditionType);
    }
}

