/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.vein.VeinTypeCluster;
import com.alcatrazescapee.oreveins.vein.VeinTypeCone;
import com.alcatrazescapee.oreveins.vein.VeinTypeCurve;
import com.alcatrazescapee.oreveins.vein.VeinTypePipe;
import com.alcatrazescapee.oreveins.vein.VeinTypeSphere;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class VeinTypeDeserializer
implements JsonDeserializer<IVeinType<?>> {
    private final Map<String, Class<? extends IVeinType>> types = new HashMap<String, Class<? extends IVeinType>>();

    public VeinTypeDeserializer() {
        this.types.put("sphere", VeinTypeSphere.class);
        this.types.put("cluster", VeinTypeCluster.class);
        this.types.put("cone", VeinTypeCone.class);
        this.types.put("pipe", VeinTypePipe.class);
        this.types.put("curve", VeinTypeCurve.class);
    }

    public IVeinType<?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        String veinType = obj.get("type").getAsString();
        if (this.types.containsKey(veinType)) {
            return (IVeinType)context.deserialize(json, (Type)this.types.get(veinType));
        }
        throw new JsonParseException("Unknown vein type " + veinType);
    }
}

