/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.util.json;

import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.WeightedList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class WeightedListDeserializer<T>
implements JsonDeserializer<IWeightedList<T>> {
    private final Class<T> elementClass;

    public WeightedListDeserializer(Class<T> elementClass) {
        this.elementClass = elementClass;
    }

    public IWeightedList<T> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive() || json.isJsonObject()) {
            Object element = context.deserialize(json, this.elementClass);
            return IWeightedList.singleton(element);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            WeightedList<Object> weightedList = new WeightedList<Object>();
            for (JsonElement element : array) {
                JsonObject obj = element.getAsJsonObject();
                double weight = obj.has("weight") ? obj.get("weight").getAsDouble() : 1.0;
                weightedList.add(weight, context.deserialize(element, this.elementClass));
            }
            return weightedList;
        }
        throw new JsonParseException("Unable to parse IBlockState List");
    }
}

