/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.vein;

import com.alcatrazescapee.oreveins.OreVeins;
import com.alcatrazescapee.oreveins.OreVeinsConfig;
import com.alcatrazescapee.oreveins.api.ICondition;
import com.alcatrazescapee.oreveins.api.IVeinType;
import com.alcatrazescapee.oreveins.cmd.CommandClearWorld;
import com.alcatrazescapee.oreveins.util.IWeightedList;
import com.alcatrazescapee.oreveins.util.json.BlockStateDeserializer;
import com.alcatrazescapee.oreveins.util.json.BlockStateListDeserializer;
import com.alcatrazescapee.oreveins.util.json.ConditionDeserializer;
import com.alcatrazescapee.oreveins.util.json.VeinTypeDeserializer;
import com.alcatrazescapee.oreveins.util.json.WeightedListDeserializer;
import com.alcatrazescapee.oreveins.vein.Indicator;
import com.alcatrazescapee.oreveins.world.WorldGenVeins;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.io.FileUtils;

public final class VeinRegistry {
    private static final BiMap<String, IVeinType> VEINS = HashBiMap.create();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(IVeinType.class, (Object)new VeinTypeDeserializer()).registerTypeAdapter(new TypeToken<List<IBlockState>>(){}.getType(), (Object)new BlockStateListDeserializer()).registerTypeAdapter(new TypeToken<IWeightedList<IBlockState>>(){}.getType(), new WeightedListDeserializer<IBlockState>(IBlockState.class)).registerTypeAdapter(new TypeToken<IWeightedList<Indicator>>(){}.getType(), new WeightedListDeserializer<Indicator>(Indicator.class)).registerTypeAdapter(IBlockState.class, (Object)new BlockStateDeserializer()).registerTypeAdapter(ICondition.class, (Object)new ConditionDeserializer()).create();
    private static File worldGenFolder;

    public static Collection<IVeinType> getVeins() {
        return VEINS.values();
    }

    public static Set<String> getNames() {
        return VEINS.keySet();
    }

    public static IVeinType getVein(String key) {
        return (IVeinType)VEINS.get((Object)key);
    }

    public static String getName(IVeinType key) {
        return (String)VEINS.inverse().get((Object)key);
    }

    public static void preInit(File modConfigDir) {
        OreVeins.getLog().info("Loading or creating ore generation config file");
        worldGenFolder = new File(modConfigDir, "oreveins");
        if (OreVeinsConfig.ALWAYS_CREATE_DEFAULT_CONFIG) {
            if (!worldGenFolder.exists() && !worldGenFolder.mkdir()) {
                OreVeins.getLog().error("Error creating world gen config folder!");
            } else {
                File defaultFile = new File(worldGenFolder, "ore_veins.json");
                String defaultData = null;
                if (defaultFile.exists()) {
                    try {
                        defaultData = FileUtils.readFileToString((File)defaultFile, (Charset)Charset.defaultCharset());
                    }
                    catch (IOException e) {
                        OreVeins.getLog().warn("Error reading default file.", (Throwable)e);
                    }
                }
                if (Strings.isNullOrEmpty(defaultData)) {
                    try {
                        FileUtils.copyInputStreamToFile((InputStream)WorldGenVeins.class.getResourceAsStream("/assets/ore_veins.json"), (File)defaultFile);
                    }
                    catch (IOException e) {
                        OreVeins.getLog().warn("Error copying data into default world gen file", (Throwable)e);
                    }
                }
            }
        }
    }

    public static void reloadVeins() {
        Path[] recursivePathList;
        try {
            recursivePathList = (Path[])Files.walk(worldGenFolder.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toArray(Path[]::new);
        }
        catch (IOException e) {
            OreVeins.getLog().error("Unable to read files in the config directory! No veins will be generated!");
            return;
        }
        for (Path path : recursivePathList) {
            try {
                String fileContents = Files.readAllLines(path).stream().reduce((x, y) -> x + y).orElse("");
                Set allVeinsJson = new JsonParser().parse(fileContents).getAsJsonObject().entrySet();
                for (Map.Entry entry : allVeinsJson) {
                    try {
                        IVeinType vein = (IVeinType)GSON.fromJson((JsonElement)entry.getValue(), IVeinType.class);
                        if (vein.isValid()) {
                            if (VEINS.containsKey(entry.getKey())) {
                                OreVeins.getLog().error("Duplicate Veins found for the name {}. One has been discarded.", entry.getKey());
                                continue;
                            }
                            VEINS.put(entry.getKey(), (Object)vein);
                            continue;
                        }
                        OreVeins.getLog().error("Vein {} is invalid. This is likely caused by one or more required parameters being left out.", entry.getKey());
                    }
                    catch (JsonParseException e) {
                        OreVeins.getLog().error("Vein {} failed to parse. This is most likely caused by incorrectly specified JSON.", entry.getKey());
                        OreVeins.getLog().error("Error: ", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                OreVeins.getLog().error("Unable to open the file at {}, skipping.", (Object)path);
                OreVeins.getLog().error("Error: ", (Throwable)e);
            }
        }
        CommandClearWorld.resetVeinStates();
        WorldGenVeins.resetChunkRadius();
        OreVeins.getLog().info("Registered {} Veins Successfully.", (Object)VeinRegistry.getVeins().size());
    }

    private VeinRegistry() {
    }
}

