/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.oreveins.world;

import com.alcatrazescapee.oreveins.OreVeins;
import com.alcatrazescapee.oreveins.OreVeinsConfig;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenReplacer {
    @SubscribeEvent
    public void onGenerateMineable(OreGenEvent.GenerateMinable event) {
        if (this.shouldBlock(event)) {
            event.setResult(Event.Result.DENY);
        }
    }

    private boolean shouldBlock(OreGenEvent.GenerateMinable event) {
        int dimensionId = event.getWorld().field_73011_w.getDimension();
        boolean found = false;
        for (int configDimId : OreVeinsConfig.STOPPED_ORES_DIMENSIONS) {
            if (dimensionId != configDimId) continue;
            found = true;
            break;
        }
        if (OreVeinsConfig.STOPPED_ORES_DIMENSIONS_IS_WHITELIST != found) {
            return false;
        }
        if (OreVeinsConfig.NO_ORES) {
            return true;
        }
        OreGenEvent.GenerateMinable.EventType type = event.getType();
        for (String s : OreVeinsConfig.STOPPED_ORES) {
            try {
                if (OreGenEvent.GenerateMinable.EventType.valueOf((String)s.toUpperCase()) != type) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                OreVeins.getLog().warn("Illegal type is specified in Ore Veins Config at STOPPED_ORES. Spelling error?");
            }
        }
        return false;
    }
}

